/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdmn.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"xml", "version", "name"})
public class UpdateDefinitionRequest {
    public static final String JSON_PROPERTY_XML = "xml";
    private String xml;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Integer version;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public UpdateDefinitionRequest xml(String xml) {
        this.xml = xml;
        return this;
    }

    @Nullable
    @JsonProperty(value="xml")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getXml() {
        return this.xml;
    }

    @JsonProperty(value="xml")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setXml(String xml) {
        this.xml = xml;
    }

    public UpdateDefinitionRequest version(Integer version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(Integer version) {
        this.version = version;
    }

    public UpdateDefinitionRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateDefinitionRequest updateDefinitionRequest = (UpdateDefinitionRequest)o;
        return Objects.equals(this.xml, updateDefinitionRequest.xml) && Objects.equals(this.version, updateDefinitionRequest.version) && Objects.equals(this.name, updateDefinitionRequest.name);
    }

    public int hashCode() {
        return Objects.hash(this.xml, this.version, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateDefinitionRequest {\n");
        sb.append("    xml: ").append(this.toIndentedString(this.xml)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getXml() != null) {
            joiner.add(String.format("%sxml%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getXml()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getVersion() != null) {
            joiner.add(String.format("%sversion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getVersion()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

