/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdmn.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.quantumdmn.client.model.ProjectPermissions;
import jakarta.annotation.Nonnull;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"global_role", "projects"})
public class UserPermissions {
    public static final String JSON_PROPERTY_GLOBAL_ROLE = "global_role";
    private String globalRole;
    public static final String JSON_PROPERTY_PROJECTS = "projects";
    private Map<String, ProjectPermissions> projects = new HashMap<String, ProjectPermissions>();

    public UserPermissions globalRole(String globalRole) {
        this.globalRole = globalRole;
        return this;
    }

    @Nonnull
    @JsonProperty(value="global_role")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getGlobalRole() {
        return this.globalRole;
    }

    @JsonProperty(value="global_role")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGlobalRole(String globalRole) {
        this.globalRole = globalRole;
    }

    public UserPermissions projects(Map<String, ProjectPermissions> projects) {
        this.projects = projects;
        return this;
    }

    public UserPermissions putProjectsItem(String key, ProjectPermissions projectsItem) {
        if (this.projects == null) {
            this.projects = new HashMap<String, ProjectPermissions>();
        }
        this.projects.put(key, projectsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="projects")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Map<String, ProjectPermissions> getProjects() {
        return this.projects;
    }

    @JsonProperty(value="projects")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProjects(Map<String, ProjectPermissions> projects) {
        this.projects = projects;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserPermissions userPermissions = (UserPermissions)o;
        return Objects.equals(this.globalRole, userPermissions.globalRole) && Objects.equals(this.projects, userPermissions.projects);
    }

    public int hashCode() {
        return Objects.hash(this.globalRole, this.projects);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserPermissions {\n");
        sb.append("    globalRole: ").append(this.toIndentedString(this.globalRole)).append("\n");
        sb.append("    projects: ").append(this.toIndentedString(this.projects)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getGlobalRole() != null) {
            joiner.add(String.format("%sglobal_role%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getGlobalRole()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getProjects() != null) {
            for (String _key : this.getProjects().keySet()) {
                if (this.getProjects().get(_key) == null) continue;
                joiner.add(this.getProjects().get(_key).toUrlQueryString(String.format("%sprojects%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

