/*
 * Copyright (C) 2013-2020 by XDEV Software, All Rights Reserved.
 *
 * This file is part of the RapidClipse Application Platform (RAP).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: AGPL-3.0-or-later
 *
 * Contributors:
 *     XDEV Software Corp. - initial API and implementation
 */
package com.rapidclipse.framework.server.webapi.visibility;

/**
 * The visibility state of an application. If the user can see the application its visibility state is visible.
 * 
 * @author XDEV Software
 * @since 10.02.00
 */
public enum VisibilityState
{
	/**
	 * The user can see the application.
	 */
	visible,
	
	/**
	 * The user can not see the application.
	 */
	hidden,
	
	/**
	 * This is usually set when the application is first loaded. The state will never change to this value
	 * afterwards.
	 */
	prerender,
	
	/**
	 * This can be set when the application is being unloaded.
	 */
	unloaded
}
