/*
 * Decompiled with CFR 0.152.
 */
package com.rapidclipse.framework.server.webapi.video;

import com.rapidclipse.framework.server.webapi.JavascriptTemplate;
import com.rapidclipse.framework.server.webapi.video.ImageWrapper;
import com.rapidclipse.framework.server.webapi.video.Source;
import com.rapidclipse.framework.server.webapi.video.VideoWrapper;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.component.polymertemplate.RepeatIndex;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.templatemodel.TemplateModel;
import elemental.json.JsonString;
import java.io.Serializable;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;

@HtmlImport(value="frontend://webapi/video.html")
@Tag(value="rap-video")
public class Video
extends JavascriptTemplate<VideoTemplateModel>
implements HasSize {
    private final List<byte[]> recordedData = new LinkedList<byte[]>();

    public Video() {
        this.setSizeFull();
    }

    public Registration addVideoConsumer(SerializableConsumer<VideoWrapper> consumer) {
        return this.registerConsumer(VideoWrapper.class, consumer);
    }

    public Registration addPictureConsumer(SerializableConsumer<ImageWrapper> consumer) {
        return this.registerConsumer(ImageWrapper.class, consumer);
    }

    public Video setSources(List<Source> sources) {
        ((VideoTemplateModel)this.getModel()).setSources(sources);
        return this;
    }

    public void addSource(Source source) {
        ((VideoTemplateModel)this.getModel()).getSources().add(source);
    }

    public void addDeviceCameraVideoSource(boolean withVideo, boolean useFrontCamera, boolean withAudio) {
        this.getElement().callJsFunction("addDeviceCameraVideoSource", new Serializable[]{Boolean.valueOf(withVideo), Boolean.valueOf(withAudio), Boolean.valueOf(useFrontCamera)});
    }

    public void removeSource(@RepeatIndex int index) {
        ((VideoTemplateModel)this.getModel()).getSources().remove(index);
    }

    public List<Source> getSources() {
        return ((VideoTemplateModel)this.getModel()).getSources();
    }

    public void startRecording() {
        this.getElement().callJsFunction("startRecording", new Serializable[0]);
    }

    public void stopRecording() {
        this.getElement().callJsFunction("stopRecording", new Serializable[0]).then(String.class, (SerializableConsumer & Serializable)mimeType -> this.notifyConsumers(VideoWrapper.class, new VideoWrapper((String)mimeType, this.recordedData)));
    }

    public void takePicture() {
        this.getElement().callJsFunction("takePicture", new Serializable[0]);
    }

    public void setWidth(String width) {
        super.setWidth(width);
        ((VideoTemplateModel)this.getModel()).setVideoWidth(width);
    }

    public void setWidthFull() {
        super.setWidthFull();
        ((VideoTemplateModel)this.getModel()).setVideoWidth("100%");
    }

    public void setHeight(String height) {
        super.setHeight(height);
        ((VideoTemplateModel)this.getModel()).setVideoHeight(height);
    }

    public void setHeightFull() {
        super.setHeightFull();
        ((VideoTemplateModel)this.getModel()).setVideoHeight("100%");
    }

    @ClientCallable
    private void receiveRecordChunk(JsonString data) {
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] decodedData = decoder.decode(data.asString().split(",")[1]);
        this.recordedData.add(decodedData);
    }

    @ClientCallable
    public void onPictureReceived(JsonString data) {
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] decodedData = decoder.decode(data.asString().split(",")[1]);
        this.notifyConsumers(ImageWrapper.class, new ImageWrapper(decodedData));
    }

    public static interface VideoTemplateModel
    extends TemplateModel {
        public void setSources(List<Source> var1);

        public List<Source> getSources();

        public void setVideoWidth(String var1);

        public void setVideoHeight(String var1);
    }
}

