/*
 * Decompiled with CFR 0.152.
 */
package com.rapidclipse.framework.server.webapi;

import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.polymertemplate.PolymerTemplate;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.templatemodel.TemplateModel;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public abstract class JavascriptTemplate<M extends TemplateModel>
extends PolymerTemplate<M> {
    private final Map<Class<?>, Set<? extends SerializableConsumer<?>>> consumers = new HashMap();

    protected JavascriptTemplate() {
    }

    protected JavascriptTemplate(HasElement parent) {
        parent.getElement().appendVirtualChild(new Element[]{this.getElement()});
    }

    protected <T extends Serializable> Registration registerConsumer(Class<T> type, SerializableConsumer<T> consumer) {
        return this.registerConsumer(type, consumer, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends Serializable> Registration registerConsumer(Class<T> type, SerializableConsumer<T> consumer, Runnable firstAddedCallback, Runnable lastRemovedCallback) {
        Map<Class<?>, Set<? extends SerializableConsumer<?>>> map = this.consumers;
        synchronized (map) {
            this.consumers.computeIfAbsent(type, t -> {
                if (firstAddedCallback != null) {
                    firstAddedCallback.run();
                }
                return new HashSet();
            }).add(consumer);
        }
        return (Registration & Serializable)() -> {
            Map<Class<?>, Set<? extends SerializableConsumer<?>>> map = this.consumers;
            synchronized (map) {
                Set<SerializableConsumer<?>> consumers = this.consumers.get(type);
                if (consumers != null) {
                    consumers.remove(consumer);
                    if (consumers.isEmpty()) {
                        this.consumers.remove(type);
                        if (lastRemovedCallback != null) {
                            lastRemovedCallback.run();
                        }
                    }
                }
            }
        };
    }

    protected <T extends Serializable> void unregisterAllConsumers(Class<T> type) {
        this.unregisterAllConsumers(type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends Serializable> void unregisterAllConsumers(Class<T> type, Runnable unregisterCallback) {
        Map<Class<?>, Set<? extends SerializableConsumer<?>>> map = this.consumers;
        synchronized (map) {
            Set<SerializableConsumer<?>> consumers = this.consumers.get(type);
            if (consumers != null && !consumers.isEmpty()) {
                consumers.clear();
                this.consumers.remove(type);
                if (unregisterCallback != null) {
                    unregisterCallback.run();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends Serializable> void notifyConsumers(Class<T> type, T object) {
        Map<Class<?>, Set<? extends SerializableConsumer<?>>> map = this.consumers;
        synchronized (map) {
            Optional.ofNullable(this.consumers.get(type)).ifPresent(set -> set.forEach(c -> c.accept((Object)object)));
        }
    }

    protected void clearConsumers() {
        this.consumers.clear();
    }
}

