/*
 * Decompiled with CFR 0.152.
 */
package com.rapidclipse.framework.server.webapi.online;

import com.rapidclipse.framework.server.webapi.JavascriptTemplate;
import com.rapidclipse.framework.server.webapi.online.OnlineState;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.templatemodel.TemplateModel;
import java.io.Serializable;

@HtmlImport(value="frontend://webapi/online.html")
@Tag(value="rap-online")
public class Online
extends JavascriptTemplate<OnlineTemplateModel> {
    public Online(HasElement parent) {
        super(parent);
    }

    public Registration addOnlineListener(SerializableConsumer<OnlineState> onOnline) {
        Runnable firstAddedCallback = () -> this.getElement().callJsFunction("registerOnlineListener", new Serializable[0]);
        Runnable lastRemovedCallback = () -> this.getElement().callJsFunction("unregisterOnlineListener", new Serializable[0]);
        return this.registerConsumer(OnlineState.class, onOnline, firstAddedCallback, lastRemovedCallback);
    }

    public void unregisterAllOnlineListeners() {
        Runnable unregisterCallback = () -> this.getElement().callJsFunction("unregisterOnlineListener", new Serializable[0]);
        this.unregisterAllConsumers(OnlineState.class, unregisterCallback);
    }

    public static void getOnlineState(SerializableConsumer<OnlineState> onStateReceived) {
        UI.getCurrent().getPage().executeJs("return navigator.onLine", new Serializable[0]).then(Boolean.class, (SerializableConsumer & Serializable)isOnline -> onStateReceived.accept((Object)(isOnline != false ? OnlineState.ONLINE : OnlineState.OFFLINE)));
    }

    @ClientCallable
    private void onOnline() {
        this.notifyConsumers(OnlineState.class, OnlineState.ONLINE);
    }

    @ClientCallable
    private void onOffline() {
        this.notifyConsumers(OnlineState.class, OnlineState.OFFLINE);
    }

    public static interface OnlineTemplateModel
    extends TemplateModel {
    }
}

