/*
 * Decompiled with CFR 0.152.
 */
package com.rapidclipse.framework.server.webapi.payment;

import com.google.gson.reflect.TypeToken;
import com.rapidclipse.framework.server.webapi.JavascriptError;
import com.rapidclipse.framework.server.webapi.JavascriptTemplate;
import com.rapidclipse.framework.server.webapi.JsonUtils;
import com.rapidclipse.framework.server.webapi.payment.PaymentRequestDetails;
import com.rapidclipse.framework.server.webapi.payment.PaymentRequestMethodData;
import com.rapidclipse.framework.server.webapi.payment.PaymentRequestOptions;
import com.rapidclipse.framework.server.webapi.payment.PaymentResult;
import com.rapidclipse.framework.server.webapi.payment.PaymentValidationError;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.templatemodel.TemplateModel;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.Consumer;

@HtmlImport(value="frontend://webapi/payment.html")
@Tag(value="rap-payment")
public class Payment
extends JavascriptTemplate<PaymentTemplateModel> {
    private Consumer<PaymentResult> onRequestPaymentResultReceived;
    private Consumer<JavascriptError> onRequestPaymentErrorReceived;
    private Consumer<PaymentResult> onRetryResultReceived;
    private Consumer<JavascriptError> onRetryErrorReceived;
    private Consumer<JavascriptError> onCompleteErrorReceived;

    public Payment(HasElement parent) {
        parent.getElement().appendVirtualChild(new Element[]{this.getElement()});
    }

    public void requestPayment(List<PaymentRequestMethodData> methodData, PaymentRequestDetails details, PaymentRequestOptions options, Consumer<PaymentResult> onResultReceived, Consumer<JavascriptError> onErrorReceived) {
        this.onRequestPaymentResultReceived = onResultReceived;
        this.onRequestPaymentErrorReceived = onErrorReceived;
        this.getElement().callJsFunction("requestPayment", new Serializable[]{JsonUtils.encodeObject(methodData), JsonUtils.encodeObject(details), JsonUtils.encodeObject(options)});
    }

    public void retry(PaymentValidationError errorFields, Consumer<PaymentResult> onResultReceived, Consumer<JavascriptError> onErrorOccurred) {
        this.onRetryResultReceived = onResultReceived;
        this.onRetryErrorReceived = onErrorOccurred;
        this.getElement().callJsFunction("retryPayment", new Serializable[]{JsonUtils.encodeObject(errorFields)});
    }

    public void complete(Result result, Consumer<JavascriptError> onErrorOccurred) {
        this.onCompleteErrorReceived = onErrorOccurred;
        this.getElement().callJsFunction("completePayment", new Serializable[]{JsonUtils.encodeObject((Object)result)});
    }

    @ClientCallable
    private void onRequestPaymentResultReceived(JsonObject result) {
        if (this.onRequestPaymentResultReceived != null) {
            Type t = new TypeToken<PaymentResult>(){}.getType();
            this.onRequestPaymentResultReceived.accept((PaymentResult)JsonUtils.GSON.fromJson(result.toJson(), t));
        }
    }

    @ClientCallable
    private void onRequestPaymentErrorReceived(JsonObject error) {
        if (this.onRequestPaymentErrorReceived != null) {
            Type t = new TypeToken<JavascriptError>(){}.getType();
            this.onRequestPaymentErrorReceived.accept((JavascriptError)JsonUtils.GSON.fromJson(error.toJson(), t));
        }
    }

    @ClientCallable
    private void onRetryResultReceived(JsonObject result) {
        if (this.onRetryResultReceived != null) {
            Type t = new TypeToken<PaymentResult>(){}.getType();
            this.onRetryResultReceived.accept((PaymentResult)JsonUtils.GSON.fromJson(result.toJson(), t));
        }
    }

    @ClientCallable
    private void onRetryErrorReceived(JsonObject error) {
        if (this.onRetryErrorReceived != null) {
            Type t = new TypeToken<JavascriptError>(){}.getType();
            this.onRetryErrorReceived.accept((JavascriptError)JsonUtils.GSON.fromJson(error.toJson(), t));
        }
    }

    @ClientCallable
    private void onCompleteErrorReceived(JsonObject error) {
        if (this.onCompleteErrorReceived != null) {
            Type t = new TypeToken<JavascriptError>(){}.getType();
            this.onCompleteErrorReceived.accept((JavascriptError)JsonUtils.GSON.fromJson(error.toJson(), t));
        }
    }

    public static interface PaymentTemplateModel
    extends TemplateModel {
    }

    public static enum Result {
        success,
        fail,
        unkown;

    }
}

