/*
 * Decompiled with CFR 0.152.
 */
package com.rapidclipse.framework.server.webapi.touch;

import com.google.gson.reflect.TypeToken;
import com.rapidclipse.framework.server.webapi.JavascriptTemplate;
import com.rapidclipse.framework.server.webapi.JsonUtils;
import com.rapidclipse.framework.server.webapi.touch.TouchEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.templatemodel.TemplateModel;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.lang.reflect.Type;

@HtmlImport(value="frontend://webapi/touch.html")
@Tag(value="rap-touch")
public class Touch
extends JavascriptTemplate<TouchTemplateModel> {
    private final HasElement target;

    public Touch(HasElement target) {
        super(target);
        this.target = target;
    }

    public Registration addTouchListener(SerializableConsumer<TouchEvent> touchListener) {
        Runnable firstAddedCallback = () -> this.getElement().callJsFunction("registerTouchListener", new Serializable[]{this.target});
        Runnable lastRemovedCallback = () -> this.getElement().callJsFunction("unregisterTouchListener", new Serializable[]{this.target});
        return this.registerConsumer(TouchEvent.class, touchListener, firstAddedCallback, lastRemovedCallback);
    }

    @ClientCallable
    private void onTouchStart(JsonObject event) {
        this.notifyTouchListener(event, TouchEvent.Type.TOUCH_START);
    }

    @ClientCallable
    private void onTouchEnd(JsonObject event) {
        this.notifyTouchListener(event, TouchEvent.Type.TOUCH_END);
    }

    @ClientCallable
    private void onTouchMove(JsonObject event) {
        this.notifyTouchListener(event, TouchEvent.Type.TOUCH_MOVE);
    }

    @ClientCallable
    private void onTouchCancel(JsonObject event) {
        this.notifyTouchListener(event, TouchEvent.Type.TOUCH_CANCEL);
    }

    private void notifyTouchListener(JsonObject eventObj, TouchEvent.Type eventType) {
        Type t = new TypeToken<TouchEvent>(){}.getType();
        TouchEvent event = (TouchEvent)JsonUtils.GSON.fromJson(eventObj.toJson(), t);
        event.type = eventType;
        this.notifyConsumers(TouchEvent.class, event);
    }

    public static interface TouchTemplateModel
    extends TemplateModel {
    }
}

