/*
 * Decompiled with CFR 0.152.
 */
package com.rapidclipse.framework.server.webapi.geolocation;

import com.googlecode.gentyref.TypeToken;
import com.rapidclipse.framework.server.webapi.JavascriptTemplate;
import com.rapidclipse.framework.server.webapi.JsonUtils;
import com.rapidclipse.framework.server.webapi.geolocation.Position;
import com.rapidclipse.framework.server.webapi.geolocation.PositionError;
import com.rapidclipse.framework.server.webapi.geolocation.PositionOptions;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.templatemodel.TemplateModel;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.lang.reflect.Type;

@HtmlImport(value="frontend://webapi/geolocation.html")
@Tag(value="rap-geolocation")
public class Geolocation
extends JavascriptTemplate<GeolocationTemplateModel> {
    public Geolocation(HasElement parent) {
        parent.getElement().appendVirtualChild(new Element[]{this.getElement()});
    }

    public Registration addPositionListener(SerializableConsumer<Position> listener) {
        return this.registerConsumer(Position.class, listener);
    }

    public Registration addPositionErrorConsumer(SerializableConsumer<PositionError> consumer) {
        return this.registerConsumer(PositionError.class, consumer);
    }

    public void getCurrentPosition(PositionOptions options) {
        this.getElement().callJsFunction("getCurrentPosition", new Serializable[]{JsonUtils.encodeObject(options)});
    }

    public Registration watchPosition(PositionOptions options) {
        this.getElement().callJsFunction("registerWatchPositionListener", new Serializable[]{JsonUtils.encodeObject(options)});
        return this::clearWatch;
    }

    public void clearWatch() {
        this.getElement().callJsFunction("unregisterWatchPositionListener", new Serializable[0]);
        this.clearConsumers();
    }

    @ClientCallable
    private void onPositionSuccess(JsonObject positionObj) {
        Type type = new TypeToken<Position>(){}.getType();
        Position position = (Position)JsonUtils.GSON.fromJson(positionObj.toJson(), type);
        this.notifyConsumers(Position.class, position);
    }

    @ClientCallable
    private void onPositionError(JsonObject errorObj) {
        Type type = new TypeToken<PositionError>(){}.getType();
        PositionError error = (PositionError)JsonUtils.GSON.fromJson(errorObj.toJson(), type);
        this.notifyConsumers(PositionError.class, error);
    }

    public static interface GeolocationTemplateModel
    extends TemplateModel {
    }
}

