/*
 * Decompiled with CFR 0.152.
 */
package com.rapidclipse.framework.server.webapi.network;

import com.googlecode.gentyref.TypeToken;
import com.rapidclipse.framework.server.webapi.JavascriptTemplate;
import com.rapidclipse.framework.server.webapi.JsonUtils;
import com.rapidclipse.framework.server.webapi.network.NetworkInformation;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.templatemodel.TemplateModel;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.function.Consumer;

@HtmlImport(value="frontend://webapi/network.html")
@Tag(value="rap-network")
public class Network
extends JavascriptTemplate<NetworkTemplateModel> {
    public Network(HasElement parent) {
        super(parent);
    }

    public Registration addNetworkInformationListener(SerializableConsumer<NetworkInformation> listener) {
        Runnable firstAddedCallback = () -> this.getElement().callJsFunction("registerOnChangeListener", new Serializable[0]);
        Runnable lastRemovedCallback = () -> this.getElement().callJsFunction("unregisterOnChangeListener", new Serializable[0]);
        return this.registerConsumer(NetworkInformation.class, listener, firstAddedCallback, lastRemovedCallback);
    }

    public static void getNetworkInformation(Consumer<NetworkInformation> callback) {
        UI.getCurrent().getPage().executeJs("const n = navigator.connection;\treturn {\t\tdownlink: n.downlink,\t\tdownlinkMax: n.downlinkMax,\t\teffectiveType: n.effectiveType,\t\trtt: n.rtt,\t\tsaveData: n.saveData,\t\ttype: n.type\t\t};", new Serializable[0]).then((SerializableConsumer & Serializable)obj -> callback.accept(Network.parseNetworkInformation(obj)));
    }

    public void clearWatch() {
        this.getElement().callJsFunction("unregisterOnChangeListener", new Serializable[0]);
        this.clearConsumers();
    }

    @ClientCallable
    private void onNetworkInformationChanged(JsonObject obj) {
        this.notifyConsumers(NetworkInformation.class, Network.parseNetworkInformation((JsonValue)obj));
    }

    private static NetworkInformation parseNetworkInformation(JsonValue json) {
        Type t = new TypeToken<NetworkInformation>(){}.getType();
        return (NetworkInformation)JsonUtils.GSON.fromJson(json.toJson(), t);
    }

    public static interface NetworkTemplateModel
    extends TemplateModel {
    }
}

