/*
 * Decompiled with CFR 0.152.
 */
package com.rapidclipse.framework.server.webapi.screen;

import com.googlecode.gentyref.TypeToken;
import com.rapidclipse.framework.server.webapi.JavascriptError;
import com.rapidclipse.framework.server.webapi.JavascriptTemplate;
import com.rapidclipse.framework.server.webapi.JsonUtils;
import com.rapidclipse.framework.server.webapi.screen.FullscreenError;
import com.rapidclipse.framework.server.webapi.screen.FullscreenExitError;
import com.rapidclipse.framework.server.webapi.screen.FullscreenOptions;
import com.rapidclipse.framework.server.webapi.screen.ScreenOrientation;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.templatemodel.TemplateModel;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.function.Consumer;

@HtmlImport(value="frontend://webapi/screen.html")
@Tag(value="rap-screen")
public class Screen
extends JavascriptTemplate<ScreenTemplateModel> {
    private final HasElement target;

    public Screen(HasElement target) {
        super(target);
        this.target = target;
    }

    public Registration addScreenOrientationListener(SerializableConsumer<ScreenOrientation> listener) {
        Runnable firstAddedCallback = () -> this.getElement().callJsFunction("registerOnScreenOrientationChangeListener", new Serializable[0]);
        Runnable lastRemovedCallback = () -> this.getElement().callJsFunction("unregisterOnScreenOrientationChangeListener", new Serializable[0]);
        return this.registerConsumer(ScreenOrientation.class, listener, firstAddedCallback, lastRemovedCallback);
    }

    public Registration addFullscreenErrorListener(SerializableConsumer<FullscreenError> listener) {
        return this.registerConsumer(FullscreenError.class, listener);
    }

    public Registration addFullscreenExitErrorListener(SerializableConsumer<FullscreenExitError> listener) {
        return this.registerConsumer(FullscreenExitError.class, listener);
    }

    public static void fullscreenEnabled(SerializableConsumer<Boolean> callback) {
        UI.getCurrent().getPage().executeJs("return document.fullscreenEnabled;", new Serializable[0]).then(Boolean.class, callback);
    }

    public void requestFullscreen(FullscreenOptions options) {
        this.getElement().callJsFunction("fullscreenElement", new Serializable[]{this.target, JsonUtils.encodeObject(options)});
    }

    public void exitFullscreen() {
        this.getElement().callJsFunction("exitFullscreen", new Serializable[0]);
    }

    public static void getScreenOrientation(Consumer<ScreenOrientation> callback) {
        UI.getCurrent().getPage().executeJs("const so = screen.orientation;   return {       type: so.type,       angle: so.angle   };", new Serializable[0]).then((SerializableConsumer & Serializable)obj -> {
            Type type = new TypeToken<ScreenOrientation>(){}.getType();
            callback.accept((ScreenOrientation)JsonUtils.GSON.fromJson(obj.toJson(), type));
        });
    }

    public void unregisterAllScreenOrientationListeners() {
        this.getElement().callJsFunction("unregisterOnScreenOrientationChangeListener", new Serializable[0]);
        this.clearConsumers();
    }

    public static void lockScreenOrientation(LockOrientation orientation) {
        UI.getCurrent().getPage().executeJs("screen.orientation.lock($0)", new Serializable[]{orientation.toString()});
    }

    public static void unlockScreenOrientation() {
        UI.getCurrent().getPage().executeJs("screen.orientation.unlock()", new Serializable[0]);
    }

    @ClientCallable
    private void onFullscreenFailed(JsonObject err) {
        Type type = new TypeToken<JavascriptError>(){}.getType();
        this.notifyConsumers(FullscreenError.class, (Serializable)JsonUtils.GSON.fromJson(err.toJson(), type));
    }

    @ClientCallable
    private void onFullscreenExitFailed(JsonObject err) {
        Type type = new TypeToken<JavascriptError>(){}.getType();
        this.notifyConsumers(FullscreenExitError.class, (Serializable)JsonUtils.GSON.fromJson(err.toJson(), type));
    }

    @ClientCallable
    private void onScreenOrientationChange(JsonObject orientation) {
        Type t = new TypeToken<ScreenOrientation>(){}.getType();
        this.notifyConsumers(ScreenOrientation.class, (Serializable)JsonUtils.GSON.fromJson(orientation.toJson(), t));
    }

    public static interface ScreenTemplateModel
    extends TemplateModel {
    }

    public static enum LockOrientation {
        any,
        natural,
        landscape,
        portrait,
        portrait_primary,
        portrait_secondary,
        landscape_primary,
        landscape_secondary;


        public String toString() {
            return this.name().replace('_', '-');
        }

        public static ScreenOrientation.OrientationType fromString(String str) {
            return ScreenOrientation.OrientationType.valueOf(str.replace('-', '_'));
        }
    }
}

