/*
 * Decompiled with CFR 0.152.
 */
package com.rapidclipse.framework.server.webapi.visibility;

import com.rapidclipse.framework.server.webapi.JavascriptTemplate;
import com.rapidclipse.framework.server.webapi.visibility.VisibilityState;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.templatemodel.TemplateModel;
import java.io.Serializable;
import java.util.function.Consumer;

@HtmlImport(value="frontend://webapi/visibility.html")
@Tag(value="rap-visibility")
public class Visibility
extends JavascriptTemplate<VisibilityTemplateModel> {
    public Visibility(HasElement parent) {
        parent.getElement().appendVirtualChild(new Element[]{this.getElement()});
    }

    public Registration addVisibilityChangeListener(SerializableConsumer<VisibilityState> onVisibilityReceived) {
        Runnable firstAddedCallback = () -> this.getElement().callJsFunction("registerVisibilityListener", new Serializable[0]);
        Runnable lastRemovedCallback = () -> this.getElement().callJsFunction("unregisterVisibilityListener", new Serializable[0]);
        return this.registerConsumer(VisibilityState.class, onVisibilityReceived, firstAddedCallback, lastRemovedCallback);
    }

    public void unregisterAllVisibilityChangeListeners() {
        this.getElement().callJsFunction("unregisterVisibilityListener", new Serializable[0]);
        this.clearConsumers();
    }

    public static void getVisibilityState(Consumer<VisibilityState> onVisibilityStateReceived) {
        UI.getCurrent().getPage().executeJs("return document.visibilityState;", new Serializable[0]).then(String.class, (SerializableConsumer & Serializable)vis -> onVisibilityStateReceived.accept(VisibilityState.valueOf(vis)));
    }

    public static void isHidden(SerializableConsumer<Boolean> onStatusReceived) {
        UI.getCurrent().getPage().executeJs("return document.hidden", new Serializable[0]).then(Boolean.class, onStatusReceived);
    }

    @ClientCallable
    private void onVisibilityChanged() {
        Visibility.getVisibilityState(state -> this.notifyConsumers(VisibilityState.class, state));
    }

    public static interface VisibilityTemplateModel
    extends TemplateModel {
    }
}

