/*
 * Decompiled with CFR 0.152.
 */
package com.rm5248.serial;

import com.rm5248.serial.SerialInputStream;
import com.rm5248.serial.SerialLineState;
import com.rm5248.serial.SerialPort;
import java.io.IOException;
import java.io.InputStream;

class BufferedSerialInputStream
extends InputStream
implements Runnable {
    private SerialInputStream stream;
    private byte[] buffer;
    private int bufferBegin;
    private int bufferEnd;
    private SerialPort callback;
    private IOException exceptionToThrow;

    BufferedSerialInputStream(SerialInputStream s, SerialPort serialPort) {
        this.stream = s;
        this.buffer = new byte[500];
        this.bufferBegin = 0;
        this.bufferEnd = 0;
        this.callback = serialPort;
        this.exceptionToThrow = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read() throws IOException {
        byte byteToReturn;
        if (this.bufferBegin != this.bufferEnd) {
            byteToReturn = this.buffer[this.bufferBegin++];
            if (this.bufferBegin < this.buffer.length) return byteToReturn;
            this.bufferBegin = 0;
            return byteToReturn;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            try {
                this.buffer.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.exceptionToThrow != null) {
                throw this.exceptionToThrow;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            byteToReturn = this.buffer[this.bufferBegin++];
            if (this.bufferBegin < this.buffer.length) return byteToReturn;
            this.bufferBegin = 0;
            return byteToReturn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        while (true) {
            byte[] byArray;
            int byteRead = 0;
            try {
                byteRead = this.stream.read();
            }
            catch (IOException e) {
                byArray = this.buffer;
                // MONITORENTER : this.buffer
                this.exceptionToThrow = e;
                this.buffer.notify();
                // MONITOREXIT : byArray
                return;
            }
            SerialLineState s = new SerialLineState();
            if ((byteRead & 0x200) > 0) {
                s.carrierDetect = true;
            }
            if ((byteRead & 0x400) > 0) {
                s.clearToSend = true;
            }
            if ((byteRead & 0x800) > 0) {
                s.dataSetReady = true;
            }
            if ((byteRead & 0x1000) > 0) {
                s.dataTerminalReady = true;
            }
            if ((byteRead & 0x2000) > 0) {
                s.requestToSend = true;
            }
            if ((byteRead & 0x4000) > 0) {
                s.ringIndicator = true;
            }
            if ((byteRead & 0x8000) > 0) {
                byArray = this.buffer;
                // MONITORENTER : this.buffer
                if (this.bufferEnd + 1 >= this.buffer.length) {
                    this.bufferEnd = 0;
                }
                this.buffer[this.bufferEnd++] = (byte)(byteRead & 0xFF);
                if (this.bufferEnd == this.bufferBegin) {
                    ++this.bufferBegin;
                    if (this.bufferBegin >= this.buffer.length) {
                        this.bufferBegin = 0;
                    }
                }
                this.buffer.notify();
                // MONITOREXIT : byArray
            }
            this.callback.postSerialChangedEvent(s);
        }
    }

    @Override
    public int available() {
        if (this.bufferEnd < this.bufferBegin) {
            return this.buffer.length - this.bufferBegin + this.bufferEnd;
        }
        return this.bufferEnd - this.bufferBegin;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int readSoFar = 0;
        if (len == 0) {
            return 0;
        }
        for (int x = off; x < len; ++x) {
            b[x] = (byte)this.read();
            if (++readSoFar > 0 && this.available() == 0) break;
        }
        return readSoFar;
    }
}

