/*
 * Decompiled with CFR 0.152.
 */
package com.rm5248.serial;

import com.rm5248.serial.BufferedSerialInputStream;
import com.rm5248.serial.NoSuchPortException;
import com.rm5248.serial.NotASerialPortException;
import com.rm5248.serial.SerialChangeListener;
import com.rm5248.serial.SerialInputStream;
import com.rm5248.serial.SerialLineState;
import com.rm5248.serial.SerialOutputStream;
import com.rm5248.serial.SimpleSerialInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SerialPort {
    private static final Logger logger = Logger.getLogger(SerialPort.class.getName());
    private static final Logger native_logger = Logger.getLogger(SerialPort.class.getName() + ".native");
    public static final int NO_CONTROL_LINE_CHANGE = 0;
    public static final int CONTROL_LINE_DTR_CHANGE = 1;
    public static final int CONTROL_LINE_RTS_CHANGE = 2;
    public static final int CONTROL_LINE_CD_CHANGE = 3;
    public static final int CONTROL_LINE_CTS_CHANGE = 4;
    public static final int CONTROL_LINE_DSR_CHANGE = 5;
    public static final int CONTROL_LINE_RI_CHANGE = 6;
    public static final int ALL_CONTROL_LINES = 7;
    private int handle;
    private boolean closed;
    private String portName;
    private volatile SerialLineState state;
    private SimpleSerialInputStream simpleSerialInputStream;
    private BufferedSerialInputStream bis;
    private SerialOutputStream outputStream;
    private SerialStateListener serialListen;
    private Object serialListenSync;
    private int controlLineFlags;
    private boolean throwIOExceptionOnInterrupt;

    private static void loadNativeLibrary() {
        String nativeLibraryPath = System.getProperty("com.rm5248.javaserial.lib.path");
        String nativeLibraryName = System.getProperty("com.rm5248.javaserial.lib.name");
        if (nativeLibraryName == null) {
            nativeLibraryName = System.mapLibraryName("javaserial");
            if (nativeLibraryName.endsWith("dylib")) {
                nativeLibraryName = nativeLibraryName.replace("dylib", "jnilib");
            }
            logger.log(Level.FINE, "No native library name provided, using default of {0}", nativeLibraryName);
        }
        if (nativeLibraryPath != null) {
            logger.log(Level.FINE, "Native library path of {0} provided", nativeLibraryPath);
            File libToLoad = new File(nativeLibraryPath, nativeLibraryName);
            logger.log(Level.FINE, "Loading library {0}", libToLoad.getAbsolutePath());
            System.load(libToLoad.getAbsolutePath());
            return;
        }
        try {
            String osName = System.getProperty("os.name");
            osName = osName.contains("Windows") ? "Windows" : (osName.contains("Mac") || osName.contains("Darwin") ? "Mac" : (osName.contains("Linux") ? "Linux" : osName.replaceAll("\\W", "")));
            String arch = System.getProperty("os.arch");
            arch.replaceAll("\\W", "");
            if (arch.equals("x86_64")) {
                arch = "amd64";
            }
            Path tempFolder = Files.createTempDirectory("javaserial", new FileAttribute[0]);
            tempFolder.toFile().deleteOnExit();
            logger.log(Level.FINER, "Created temp folder of {0}", tempFolder);
            File extractedLib = new File(tempFolder.toFile(), nativeLibraryName);
            String fileToExtract = "/" + osName + "/" + arch + "/" + nativeLibraryName;
            logger.log(Level.FINER, "About to extract {0} from JAR", fileToExtract);
            InputStream library = SerialPort.class.getClass().getResourceAsStream(fileToExtract);
            Files.copy(library, extractedLib.toPath(), new CopyOption[0]);
            extractedLib.deleteOnExit();
            System.load(extractedLib.getAbsolutePath());
        }
        catch (IOException e) {
            throw new UnsatisfiedLinkError("Unable to create temp directory or extract: " + e.getMessage());
        }
    }

    public SerialPort(String portName) throws NoSuchPortException, NotASerialPortException {
        this(portName, 7);
    }

    public SerialPort(String portName, int controlLineFlags) throws NoSuchPortException, NotASerialPortException {
        this(portName, BaudRate.B9600, controlLineFlags);
    }

    public SerialPort(String portName, boolean keepSettings) throws NoSuchPortException, NotASerialPortException {
        this(portName, keepSettings, 7);
    }

    public SerialPort(String portName, boolean keepSettings, int controlFlags) throws NoSuchPortException, NotASerialPortException {
        if (portName == null) {
            throw new IllegalArgumentException("portName must not be null");
        }
        if (keepSettings) {
            this.handle = -1;
            this.handle = this.openPort(portName);
            this.portName = portName;
            if (this.controlLineFlags == 0) {
                logger.log(Level.FINE, "Creating a new SimpleSerialInputStream - not monitoring for control line change");
                this.simpleSerialInputStream = new SimpleSerialInputStream(this.handle);
            } else {
                logger.log(Level.FINE, "Creating a new BufferedSerialInputStream - monitoring for control line change");
                SerialInputStream sis = new SerialInputStream(this.handle);
                this.bis = new BufferedSerialInputStream(sis, this);
            }
            this.outputStream = new SerialOutputStream(this.handle);
            this.closed = false;
            this.controlLineFlags = controlFlags;
            SerialLineState s = new SerialLineState();
            int state = this.getSerialLineStateInternalNonblocking();
            if ((state & 1) > 0) {
                s.carrierDetect = true;
            }
            if ((state & 2) > 0) {
                s.clearToSend = true;
            }
            if ((state & 4) > 0) {
                s.dataSetReady = true;
            }
            if ((state & 8) > 0) {
                s.dataTerminalReady = true;
            }
            if ((state & 0x10) > 0) {
                s.requestToSend = true;
            }
            if ((state & 0x20) > 0) {
                s.ringIndicator = true;
            }
            this.state = s;
            if (this.controlLineFlags != 0) {
                this.serialListenSync = new Object();
                new Thread((Runnable)this.bis, "BufferedSerialReader-" + portName).start();
            }
        } else {
            this.doOpenSerialPort(portName, BaudRate.B9600, DataBits.DATABITS_8, StopBits.STOPBITS_1, Parity.NONE, FlowControl.NONE, controlFlags);
        }
    }

    public SerialPort(String portName, BaudRate rate) throws NoSuchPortException, NotASerialPortException {
        this(portName, rate, 7);
    }

    public SerialPort(String portName, BaudRate rate, int controlLines) throws NoSuchPortException, NotASerialPortException {
        this(portName, rate, DataBits.DATABITS_8, controlLines);
    }

    public SerialPort(String portName, BaudRate rate, DataBits data) throws NoSuchPortException, NotASerialPortException {
        this(portName, rate, data, StopBits.STOPBITS_1, 7);
    }

    public SerialPort(String portName, BaudRate rate, DataBits data, int controlLineFlags) throws NoSuchPortException, NotASerialPortException {
        this.doOpenSerialPort(portName, rate, data, StopBits.STOPBITS_1, Parity.NONE, FlowControl.NONE, controlLineFlags);
    }

    public SerialPort(String portName, BaudRate rate, DataBits data, StopBits stop) throws NoSuchPortException, NotASerialPortException {
        this.doOpenSerialPort(portName, rate, data, stop, Parity.NONE, FlowControl.NONE, 7);
    }

    public SerialPort(String portName, BaudRate rate, DataBits data, StopBits stop, int controlFlags) throws NoSuchPortException, NotASerialPortException {
        this.doOpenSerialPort(portName, rate, data, stop, Parity.NONE, FlowControl.NONE, controlFlags);
    }

    public SerialPort(String portName, BaudRate rate, DataBits data, StopBits stop, Parity parity) throws NoSuchPortException, NotASerialPortException {
        this.doOpenSerialPort(portName, rate, data, stop, parity, FlowControl.NONE, 7);
    }

    public SerialPort(String portName, BaudRate rate, DataBits data, StopBits stop, Parity parity, int controlLineFlags) throws NoSuchPortException, NotASerialPortException {
        this(portName, rate, data, stop, parity, FlowControl.NONE, controlLineFlags);
    }

    public SerialPort(String portName, BaudRate rate, DataBits data, StopBits stop, Parity parity, FlowControl flow) throws NoSuchPortException, NotASerialPortException {
        this(portName, rate, data, stop, parity, flow, 7);
    }

    public SerialPort(String portName, BaudRate rate, DataBits data, StopBits stop, Parity parity, FlowControl flow, int controlFlags) throws NoSuchPortException, NotASerialPortException {
        this.doOpenSerialPort(portName, rate, data, stop, parity, flow, controlFlags);
    }

    private void doOpenSerialPort(String portName, BaudRate rate, DataBits data, StopBits stop, Parity parity, FlowControl flow, int controlFlags) throws NoSuchPortException, NotASerialPortException {
        int myRate = 0;
        int myData = 0;
        int myStop = 0;
        int myParity = 0;
        int myFlow = 0;
        this.handle = -1;
        this.throwIOExceptionOnInterrupt = false;
        if (portName == null) {
            throw new IllegalArgumentException("portName must not be null");
        }
        if (rate == null) {
            throw new IllegalArgumentException("rate must not be null");
        }
        if (data == null) {
            throw new IllegalArgumentException("data must not be null");
        }
        if (stop == null) {
            throw new IllegalArgumentException("stop must not be null");
        }
        if (parity == null) {
            throw new IllegalArgumentException("parity must not be null");
        }
        if (flow == null) {
            throw new IllegalArgumentException("flow must not be null");
        }
        logger.log(Level.INFO, "Opening up serial port {0} with the following settings: speed:{1} data:{2} stop:{3} parity:{4} flow:{5}", new Object[]{portName, rate, data, stop, parity, flow});
        this.portName = portName;
        this.closed = false;
        this.controlLineFlags = controlFlags;
        switch (rate) {
            case B0: {
                myRate = 0;
                break;
            }
            case B50: {
                myRate = 50;
                break;
            }
            case B75: {
                myRate = 75;
                break;
            }
            case B110: {
                myRate = 110;
                break;
            }
            case B134: {
                myRate = 134;
                break;
            }
            case B150: {
                myRate = 150;
                break;
            }
            case B200: {
                myRate = 200;
                break;
            }
            case B300: {
                myRate = 300;
                break;
            }
            case B600: {
                myRate = 600;
                break;
            }
            case B1200: {
                myRate = 1200;
                break;
            }
            case B1800: {
                myRate = 1800;
                break;
            }
            case B2400: {
                myRate = 2400;
                break;
            }
            case B4800: {
                myRate = 4800;
                break;
            }
            case B9600: {
                myRate = 9600;
                break;
            }
            case B38400: {
                myRate = 38400;
                break;
            }
            case B115200: {
                myRate = 115200;
            }
        }
        switch (data) {
            case DATABITS_5: {
                myData = 5;
                break;
            }
            case DATABITS_6: {
                myData = 6;
                break;
            }
            case DATABITS_7: {
                myData = 7;
                break;
            }
            case DATABITS_8: {
                myData = 8;
            }
        }
        switch (stop) {
            case STOPBITS_1: {
                myStop = 1;
                break;
            }
            case STOPBITS_2: {
                myStop = 2;
            }
        }
        switch (parity) {
            case NONE: {
                myParity = 0;
                break;
            }
            case ODD: {
                myParity = 1;
                break;
            }
            case EVEN: {
                myParity = 2;
            }
        }
        switch (flow) {
            case NONE: {
                myFlow = 0;
                break;
            }
            case HARDWARE: {
                myFlow = 1;
                break;
            }
            case SOFTWARE: {
                myFlow = 2;
            }
        }
        this.handle = this.openPort(portName, myRate, myData, myStop, myParity, myFlow);
        if (this.controlLineFlags == 0) {
            logger.log(Level.FINE, "Creating a new SimpleSerialInputStream - not monitoring for control line change");
            this.simpleSerialInputStream = new SimpleSerialInputStream(this.handle);
        } else {
            logger.log(Level.FINE, "Creating a new BufferedSerialInputStream - monitoring for control line change");
            SerialInputStream sis = new SerialInputStream(this.handle);
            this.bis = new BufferedSerialInputStream(sis, this);
        }
        this.outputStream = new SerialOutputStream(this.handle);
        SerialLineState s = new SerialLineState();
        int state = this.getSerialLineStateInternalNonblocking();
        if ((state & 1) > 0) {
            s.carrierDetect = true;
        }
        if ((state & 2) > 0) {
            s.clearToSend = true;
        }
        if ((state & 4) > 0) {
            s.dataSetReady = true;
        }
        if ((state & 8) > 0) {
            s.dataTerminalReady = true;
        }
        if ((state & 0x10) > 0) {
            s.requestToSend = true;
        }
        if ((state & 0x20) > 0) {
            s.ringIndicator = true;
        }
        this.state = s;
        if (this.controlLineFlags != 0) {
            this.serialListenSync = new Object();
            new Thread((Runnable)this.bis, "BufferedSerialReader-" + portName).start();
        }
    }

    public void setBaudRate(BaudRate rate) {
        int myRate = 0;
        if (this.closed) {
            throw new IllegalStateException("Cannot set the BaudRate once the port has been closed.");
        }
        if (rate == null) {
            throw new IllegalArgumentException("rate must not be null");
        }
        switch (rate) {
            case B0: {
                myRate = 0;
                break;
            }
            case B50: {
                myRate = 50;
                break;
            }
            case B75: {
                myRate = 75;
                break;
            }
            case B110: {
                myRate = 110;
                break;
            }
            case B134: {
                myRate = 134;
                break;
            }
            case B150: {
                myRate = 150;
                break;
            }
            case B200: {
                myRate = 200;
                break;
            }
            case B300: {
                myRate = 300;
                break;
            }
            case B600: {
                myRate = 600;
                break;
            }
            case B1200: {
                myRate = 1200;
                break;
            }
            case B1800: {
                myRate = 1800;
                break;
            }
            case B2400: {
                myRate = 2400;
                break;
            }
            case B4800: {
                myRate = 4800;
                break;
            }
            case B9600: {
                myRate = 9600;
                break;
            }
            case B38400: {
                myRate = 38400;
                break;
            }
            case B115200: {
                myRate = 115200;
            }
        }
        this.setBaudRate(myRate);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void finalize() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.doClose();
        if (this.serialListen != null) {
            this.serialListen.doStop();
        }
        if (this.serialListenSync != null) {
            Object object = this.serialListenSync;
            synchronized (object) {
                this.serialListenSync.notify();
            }
        }
    }

    public InputStream getInputStream() {
        if (this.isClosed()) {
            throw new IllegalStateException("Cannot get the input stream once the port has been closed.");
        }
        if (this.bis != null) {
            return this.bis;
        }
        if (this.simpleSerialInputStream != null) {
            return this.simpleSerialInputStream;
        }
        logger.log(Level.SEVERE, "Tried to get input stream, but both BufferedSerialInputStream and SimpleSerialInputStream null");
        return null;
    }

    public void setInterruptCausesIOException(boolean interruptCausesIOException) {
        this.throwIOExceptionOnInterrupt = interruptCausesIOException;
        if (this.bis != null) {
            this.bis.setInterruptCausesIOException(interruptCausesIOException);
        } else if (this.simpleSerialInputStream != null) {
            // empty if block
        }
    }

    public OutputStream getOutputStream() {
        if (this.isClosed()) {
            throw new IllegalStateException("Cannot get the output stream once the port has been closed.");
        }
        return this.outputStream;
    }

    public void setStopBits(StopBits stop) {
        int myStop = 0;
        if (this.closed) {
            throw new IllegalStateException("Cannot set the StopBits once the port has been closed.");
        }
        if (stop == null) {
            throw new IllegalArgumentException("stop must not be null");
        }
        switch (stop) {
            case STOPBITS_1: {
                myStop = 1;
                break;
            }
            case STOPBITS_2: {
                myStop = 2;
            }
        }
        this.setStopBits(myStop);
    }

    public void setDataSize(DataBits data) {
        int myData = 0;
        if (this.closed) {
            throw new IllegalStateException("Cannot set the DataBits once the port has been closed.");
        }
        if (data == null) {
            throw new IllegalArgumentException("data must not be null");
        }
        switch (data) {
            case DATABITS_5: {
                myData = 5;
                break;
            }
            case DATABITS_6: {
                myData = 6;
                break;
            }
            case DATABITS_7: {
                myData = 7;
                break;
            }
            case DATABITS_8: {
                myData = 8;
            }
        }
        this.setCharSize(myData);
    }

    public void setParity(Parity parity) {
        int myParity = 0;
        if (this.closed) {
            throw new IllegalStateException("Cannot set the parity once the port has been closed.");
        }
        if (parity == null) {
            throw new IllegalArgumentException("parity must not be null");
        }
        switch (parity) {
            case NONE: {
                myParity = 0;
                break;
            }
            case ODD: {
                myParity = 1;
                break;
            }
            case EVEN: {
                myParity = 2;
            }
        }
        this.setParity(myParity);
    }

    public SerialLineState getSerialLineState() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Cannot get the serial line state once the port has been closed.");
        }
        int gotState = this.getSerialLineStateInternalNonblocking();
        SerialLineState s = new SerialLineState();
        if ((gotState & 1) > 0) {
            s.carrierDetect = true;
        }
        if ((gotState & 2) > 0) {
            s.clearToSend = true;
        }
        if ((gotState & 4) > 0) {
            s.dataSetReady = true;
        }
        if ((gotState & 8) > 0) {
            s.dataTerminalReady = true;
        }
        if ((gotState & 0x10) > 0) {
            s.requestToSend = true;
        }
        if ((gotState & 0x20) > 0) {
            s.ringIndicator = true;
        }
        return s;
    }

    public void setSerialLineState(SerialLineState state) {
        if (this.closed) {
            throw new IllegalStateException("Cannot set the serial line state once the port has been closed.");
        }
        this.setSerialLineStateInternal(state);
    }

    public BaudRate getBaudRate() {
        if (this.closed) {
            throw new IllegalStateException("Cannot get the baud rate once the port has been closed.");
        }
        int baudRate = this.getBaudRateInternal();
        BaudRate toReturn = BaudRate.B0;
        switch (baudRate) {
            case 0: {
                toReturn = BaudRate.B0;
                break;
            }
            case 50: {
                toReturn = BaudRate.B50;
                break;
            }
            case 75: {
                toReturn = BaudRate.B75;
                break;
            }
            case 110: {
                toReturn = BaudRate.B110;
                break;
            }
            case 134: {
                toReturn = BaudRate.B134;
                break;
            }
            case 150: {
                toReturn = BaudRate.B150;
                break;
            }
            case 200: {
                toReturn = BaudRate.B200;
                break;
            }
            case 300: {
                toReturn = BaudRate.B300;
                break;
            }
            case 600: {
                toReturn = BaudRate.B600;
                break;
            }
            case 1200: {
                toReturn = BaudRate.B1200;
                break;
            }
            case 1800: {
                toReturn = BaudRate.B1800;
                break;
            }
            case 2400: {
                toReturn = BaudRate.B2400;
                break;
            }
            case 4800: {
                toReturn = BaudRate.B4800;
                break;
            }
            case 9600: {
                toReturn = BaudRate.B9600;
                break;
            }
            case 38400: {
                toReturn = BaudRate.B38400;
                break;
            }
            case 115200: {
                toReturn = BaudRate.B115200;
            }
        }
        return toReturn;
    }

    public DataBits getDataBits() {
        if (this.closed) {
            throw new IllegalStateException("Cannot get the data bits once the port has been closed.");
        }
        int dataBits = this.getCharSizeInternal();
        DataBits bits = DataBits.DATABITS_8;
        switch (dataBits) {
            case 8: {
                bits = DataBits.DATABITS_8;
                break;
            }
            case 7: {
                bits = DataBits.DATABITS_7;
                break;
            }
            case 6: {
                bits = DataBits.DATABITS_6;
                break;
            }
            case 5: {
                bits = DataBits.DATABITS_5;
            }
        }
        return bits;
    }

    public StopBits getStopBits() {
        if (this.closed) {
            throw new IllegalStateException("Cannot get stop bits once the port has been closed.");
        }
        int stopBits = this.getStopBitsInternal();
        StopBits bits = StopBits.STOPBITS_1;
        switch (stopBits) {
            case 1: {
                bits = StopBits.STOPBITS_1;
                break;
            }
            case 2: {
                bits = StopBits.STOPBITS_2;
            }
        }
        return bits;
    }

    public Parity getParity() {
        if (this.closed) {
            throw new IllegalStateException("Cannot get the parity once the port has been closed.");
        }
        int parity = this.getParityInternal();
        Parity par = Parity.NONE;
        switch (parity) {
            case 0: {
                par = Parity.NONE;
                break;
            }
            case 1: {
                par = Parity.ODD;
                break;
            }
            case 2: {
                par = Parity.EVEN;
            }
        }
        return par;
    }

    public FlowControl getFlowControl() {
        if (this.closed) {
            throw new IllegalStateException("Cannot get the flow once the port has been closed.");
        }
        int flowControl = this.getFlowControlInternal();
        FlowControl cont = FlowControl.NONE;
        switch (flowControl) {
            case 0: {
                cont = FlowControl.NONE;
                break;
            }
            case 1: {
                cont = FlowControl.HARDWARE;
                break;
            }
            case 2: {
                cont = FlowControl.SOFTWARE;
            }
        }
        return cont;
    }

    public void setFlowControl(FlowControl flow) {
        if (this.closed) {
            throw new IllegalStateException("Cannot set flow once the port has been closed.");
        }
        switch (flow) {
            case HARDWARE: {
                this.setFlowControl(1);
                break;
            }
            case NONE: {
                this.setFlowControl(0);
                break;
            }
            case SOFTWARE: {
                this.setFlowControl(2);
            }
        }
    }

    public void setSerialChangeListener(SerialChangeListener listen) {
        if (this.serialListen != null) {
            this.serialListen.doStop();
        }
        if (listen != null && this.controlLineFlags != 0) {
            this.serialListen = new SerialStateListener(listen);
            new Thread((Runnable)this.serialListen, "SerialListen-" + this.portName).start();
        }
    }

    public String getPortName() {
        return this.portName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postSerialChangedEvent(SerialLineState newState) {
        if (!this.state.equals(newState)) {
            SerialLineState oldState = this.state;
            boolean update = false;
            this.state = newState;
            if (oldState.carrierDetect != newState.carrierDetect && (this.controlLineFlags & 3) != 0) {
                update = true;
            }
            if (oldState.clearToSend != newState.clearToSend && (this.controlLineFlags & 4) != 0) {
                update = true;
            }
            if (oldState.dataSetReady != newState.dataSetReady && (this.controlLineFlags & 5) != 0) {
                update = true;
            }
            if (oldState.dataTerminalReady != newState.dataTerminalReady && (this.controlLineFlags & 1) != 0) {
                update = true;
            }
            if (oldState.requestToSend != newState.requestToSend && (this.controlLineFlags & 2) != 0) {
                update = true;
            }
            if (oldState.ringIndicator != newState.ringIndicator && (this.controlLineFlags & 6) != 0) {
                update = true;
            }
            if (update) {
                Object object = this.serialListenSync;
                synchronized (object) {
                    this.serialListenSync.notify();
                }
            }
        }
    }

    private native int openPort(String var1, int var2, int var3, int var4, int var5, int var6) throws NoSuchPortException, NotASerialPortException;

    private native int openPort(String var1) throws NoSuchPortException, NotASerialPortException;

    private native void doClose();

    private native boolean setBaudRate(int var1);

    private native int getBaudRateInternal();

    private native boolean setStopBits(int var1);

    private native int getStopBitsInternal();

    private native boolean setCharSize(int var1);

    private native int getCharSizeInternal();

    private native boolean setParity(int var1);

    private native int getParityInternal();

    private native boolean setFlowControl(int var1);

    private native int getFlowControlInternal();

    protected native int getSerialLineStateInternalNonblocking();

    private native int setSerialLineStateInternal(SerialLineState var1);

    public static int getMajorVersion() {
        return 0;
    }

    public static int getMinorVersion() {
        return 8;
    }

    public static native int getMajorNativeVersion();

    public static native int getMinorNativeVersion();

    public static native String[] getSerialPorts();

    static {
        SerialPort.loadNativeLibrary();
    }

    public static enum FlowControl {
        NONE,
        HARDWARE,
        SOFTWARE;

    }

    public static enum Parity {
        NONE,
        EVEN,
        ODD;

    }

    public static enum StopBits {
        STOPBITS_1,
        STOPBITS_2;

    }

    public static enum DataBits {
        DATABITS_5,
        DATABITS_6,
        DATABITS_7,
        DATABITS_8;

    }

    public static enum BaudRate {
        B0,
        B50,
        B75,
        B110,
        B134,
        B150,
        B200,
        B300,
        B600,
        B1200,
        B1800,
        B2400,
        B4800,
        B9600,
        B38400,
        B115200;

    }

    private class SerialStateListener
    implements Runnable {
        private volatile boolean stop = false;
        private SerialChangeListener listen;

        SerialStateListener(SerialChangeListener listen) {
            this.listen = listen;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stop) {
                Object object = SerialPort.this.serialListenSync;
                synchronized (object) {
                    try {
                        SerialPort.this.serialListenSync.wait();
                        if (this.stop) {
                            break;
                        }
                        this.listen.serialStateChanged(SerialPort.this.state);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        void doStop() {
            this.stop = true;
        }
    }
}

