/**
 * This file was auto-generated by Fern from our API Definition.
 */

package resources.rules.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(
    builder = ListResponseItem.Builder.class
)
public final class ListResponseItem {
  private final Optional<String> id;

  private final Optional<String> name;

  private final Optional<String> description;

  private final Optional<String> createdAt;

  private final Optional<String> slug;

  private final Optional<List<ListResponseItemRequestSchemaItem>> requestSchema;

  private final Optional<List<ListResponseItemResponseSchemaItem>> responseSchema;

  private final Map<String, Object> additionalProperties;

  private ListResponseItem(Optional<String> id, Optional<String> name, Optional<String> description,
      Optional<String> createdAt, Optional<String> slug,
      Optional<List<ListResponseItemRequestSchemaItem>> requestSchema,
      Optional<List<ListResponseItemResponseSchemaItem>> responseSchema,
      Map<String, Object> additionalProperties) {
    this.id = id;
    this.name = name;
    this.description = description;
    this.createdAt = createdAt;
    this.slug = slug;
    this.requestSchema = requestSchema;
    this.responseSchema = responseSchema;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The unique identifier for the rule.
   */
  @JsonProperty("id")
  public Optional<String> getId() {
    return id;
  }

  /**
   * @return The name of the rule.
   */
  @JsonProperty("name")
  public Optional<String> getName() {
    return name;
  }

  /**
   * @return The description of the rule.
   */
  @JsonProperty("description")
  public Optional<String> getDescription() {
    return description;
  }

  /**
   * @return The creation date of the rule.
   */
  @JsonProperty("created_at")
  public Optional<String> getCreatedAt() {
    return createdAt;
  }

  /**
   * @return The unique slug for the rule used in API requests.
   */
  @JsonProperty("slug")
  public Optional<String> getSlug() {
    return slug;
  }

  @JsonProperty("request_schema")
  public Optional<List<ListResponseItemRequestSchemaItem>> getRequestSchema() {
    return requestSchema;
  }

  @JsonProperty("response_schema")
  public Optional<List<ListResponseItemResponseSchemaItem>> getResponseSchema() {
    return responseSchema;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ListResponseItem && equalTo((ListResponseItem) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ListResponseItem other) {
    return id.equals(other.id) && name.equals(other.name) && description.equals(other.description) && createdAt.equals(other.createdAt) && slug.equals(other.slug) && requestSchema.equals(other.requestSchema) && responseSchema.equals(other.responseSchema);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id, this.name, this.description, this.createdAt, this.slug, this.requestSchema, this.responseSchema);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> id = Optional.empty();

    private Optional<String> name = Optional.empty();

    private Optional<String> description = Optional.empty();

    private Optional<String> createdAt = Optional.empty();

    private Optional<String> slug = Optional.empty();

    private Optional<List<ListResponseItemRequestSchemaItem>> requestSchema = Optional.empty();

    private Optional<List<ListResponseItemResponseSchemaItem>> responseSchema = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(ListResponseItem other) {
      id(other.getId());
      name(other.getName());
      description(other.getDescription());
      createdAt(other.getCreatedAt());
      slug(other.getSlug());
      requestSchema(other.getRequestSchema());
      responseSchema(other.getResponseSchema());
      return this;
    }

    @JsonSetter(
        value = "id",
        nulls = Nulls.SKIP
    )
    public Builder id(Optional<String> id) {
      this.id = id;
      return this;
    }

    public Builder id(String id) {
      this.id = Optional.of(id);
      return this;
    }

    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public Builder name(Optional<String> name) {
      this.name = name;
      return this;
    }

    public Builder name(String name) {
      this.name = Optional.of(name);
      return this;
    }

    @JsonSetter(
        value = "description",
        nulls = Nulls.SKIP
    )
    public Builder description(Optional<String> description) {
      this.description = description;
      return this;
    }

    public Builder description(String description) {
      this.description = Optional.of(description);
      return this;
    }

    @JsonSetter(
        value = "created_at",
        nulls = Nulls.SKIP
    )
    public Builder createdAt(Optional<String> createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder createdAt(String createdAt) {
      this.createdAt = Optional.of(createdAt);
      return this;
    }

    @JsonSetter(
        value = "slug",
        nulls = Nulls.SKIP
    )
    public Builder slug(Optional<String> slug) {
      this.slug = slug;
      return this;
    }

    public Builder slug(String slug) {
      this.slug = Optional.of(slug);
      return this;
    }

    @JsonSetter(
        value = "request_schema",
        nulls = Nulls.SKIP
    )
    public Builder requestSchema(Optional<List<ListResponseItemRequestSchemaItem>> requestSchema) {
      this.requestSchema = requestSchema;
      return this;
    }

    public Builder requestSchema(List<ListResponseItemRequestSchemaItem> requestSchema) {
      this.requestSchema = Optional.of(requestSchema);
      return this;
    }

    @JsonSetter(
        value = "response_schema",
        nulls = Nulls.SKIP
    )
    public Builder responseSchema(
        Optional<List<ListResponseItemResponseSchemaItem>> responseSchema) {
      this.responseSchema = responseSchema;
      return this;
    }

    public Builder responseSchema(List<ListResponseItemResponseSchemaItem> responseSchema) {
      this.responseSchema = Optional.of(responseSchema);
      return this;
    }

    public ListResponseItem build() {
      return new ListResponseItem(id, name, description, createdAt, slug, requestSchema, responseSchema, additionalProperties);
    }
  }
}
