/**
 * This file was auto-generated by Fern from our API Definition.
 */

package resources.rules.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(
    builder = ListResponseItemResponseSchemaItem.Builder.class
)
public final class ListResponseItemResponseSchemaItem {
  private final Optional<String> key;

  private final Optional<Boolean> show;

  private final Optional<String> name;

  private final Optional<String> description;

  private final Optional<String> type;

  private final Optional<String> defaultValue;

  private final Optional<String> defaultComputedValue;

  private final Optional<String> transform;

  private final Map<String, Object> additionalProperties;

  private ListResponseItemResponseSchemaItem(Optional<String> key, Optional<Boolean> show,
      Optional<String> name, Optional<String> description, Optional<String> type,
      Optional<String> defaultValue, Optional<String> defaultComputedValue,
      Optional<String> transform, Map<String, Object> additionalProperties) {
    this.key = key;
    this.show = show;
    this.name = name;
    this.description = description;
    this.type = type;
    this.defaultValue = defaultValue;
    this.defaultComputedValue = defaultComputedValue;
    this.transform = transform;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The key for the response field.
   */
  @JsonProperty("key")
  public Optional<String> getKey() {
    return key;
  }

  /**
   * @return Whether the field is visible in the rule editor.
   */
  @JsonProperty("show")
  public Optional<Boolean> getShow() {
    return show;
  }

  /**
   * @return The name of the response field.
   */
  @JsonProperty("name")
  public Optional<String> getName() {
    return name;
  }

  /**
   * @return The description of the response field.
   */
  @JsonProperty("description")
  public Optional<String> getDescription() {
    return description;
  }

  /**
   * @return The data type of the response field.
   */
  @JsonProperty("type")
  public Optional<String> getType() {
    return type;
  }

  /**
   * @return The default value of the response field.
   */
  @JsonProperty("defaultValue")
  public Optional<String> getDefaultValue() {
    return defaultValue;
  }

  /**
   * @return The computed default value of the response field.
   */
  @JsonProperty("defaultComputedValue")
  public Optional<String> getDefaultComputedValue() {
    return defaultComputedValue;
  }

  /**
   * @return The transformation applied to the response field.
   */
  @JsonProperty("transform")
  public Optional<String> getTransform() {
    return transform;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ListResponseItemResponseSchemaItem && equalTo((ListResponseItemResponseSchemaItem) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ListResponseItemResponseSchemaItem other) {
    return key.equals(other.key) && show.equals(other.show) && name.equals(other.name) && description.equals(other.description) && type.equals(other.type) && defaultValue.equals(other.defaultValue) && defaultComputedValue.equals(other.defaultComputedValue) && transform.equals(other.transform);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.key, this.show, this.name, this.description, this.type, this.defaultValue, this.defaultComputedValue, this.transform);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> key = Optional.empty();

    private Optional<Boolean> show = Optional.empty();

    private Optional<String> name = Optional.empty();

    private Optional<String> description = Optional.empty();

    private Optional<String> type = Optional.empty();

    private Optional<String> defaultValue = Optional.empty();

    private Optional<String> defaultComputedValue = Optional.empty();

    private Optional<String> transform = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(ListResponseItemResponseSchemaItem other) {
      key(other.getKey());
      show(other.getShow());
      name(other.getName());
      description(other.getDescription());
      type(other.getType());
      defaultValue(other.getDefaultValue());
      defaultComputedValue(other.getDefaultComputedValue());
      transform(other.getTransform());
      return this;
    }

    @JsonSetter(
        value = "key",
        nulls = Nulls.SKIP
    )
    public Builder key(Optional<String> key) {
      this.key = key;
      return this;
    }

    public Builder key(String key) {
      this.key = Optional.of(key);
      return this;
    }

    @JsonSetter(
        value = "show",
        nulls = Nulls.SKIP
    )
    public Builder show(Optional<Boolean> show) {
      this.show = show;
      return this;
    }

    public Builder show(Boolean show) {
      this.show = Optional.of(show);
      return this;
    }

    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public Builder name(Optional<String> name) {
      this.name = name;
      return this;
    }

    public Builder name(String name) {
      this.name = Optional.of(name);
      return this;
    }

    @JsonSetter(
        value = "description",
        nulls = Nulls.SKIP
    )
    public Builder description(Optional<String> description) {
      this.description = description;
      return this;
    }

    public Builder description(String description) {
      this.description = Optional.of(description);
      return this;
    }

    @JsonSetter(
        value = "type",
        nulls = Nulls.SKIP
    )
    public Builder type(Optional<String> type) {
      this.type = type;
      return this;
    }

    public Builder type(String type) {
      this.type = Optional.of(type);
      return this;
    }

    @JsonSetter(
        value = "defaultValue",
        nulls = Nulls.SKIP
    )
    public Builder defaultValue(Optional<String> defaultValue) {
      this.defaultValue = defaultValue;
      return this;
    }

    public Builder defaultValue(String defaultValue) {
      this.defaultValue = Optional.of(defaultValue);
      return this;
    }

    @JsonSetter(
        value = "defaultComputedValue",
        nulls = Nulls.SKIP
    )
    public Builder defaultComputedValue(Optional<String> defaultComputedValue) {
      this.defaultComputedValue = defaultComputedValue;
      return this;
    }

    public Builder defaultComputedValue(String defaultComputedValue) {
      this.defaultComputedValue = Optional.of(defaultComputedValue);
      return this;
    }

    @JsonSetter(
        value = "transform",
        nulls = Nulls.SKIP
    )
    public Builder transform(Optional<String> transform) {
      this.transform = transform;
      return this;
    }

    public Builder transform(String transform) {
      this.transform = Optional.of(transform);
      return this;
    }

    public ListResponseItemResponseSchemaItem build() {
      return new ListResponseItemResponseSchemaItem(key, show, name, description, type, defaultValue, defaultComputedValue, transform, additionalProperties);
    }
  }
}
