/*
 * Decompiled with CFR 0.152.
 */
package resources.rules;

import com.fasterxml.jackson.core.type.TypeReference;
import core.ApiError;
import core.ClientOptions;
import core.MediaTypes;
import core.ObjectMappers;
import core.RequestOptions;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import resources.rules.types.ListResponseItem;
import resources.rules.types.UsageResponse;

public class RulesClient {
    protected final ClientOptions clientOptions;

    public RulesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public Map<String, Object> solve(String slug, Map<String, Object> request) {
        return this.solve(slug, request, null);
    }

    public Map<String, Object> solve(String slug, Map<String, Object> request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("api/v1/solve").addPathSegment(slug).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (Map)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Map<String, Object>> bulkSolve(String slug, List<Map<String, Object>> request) {
        return this.bulkSolve(slug, request, null);
    }

    public List<Map<String, Object>> bulkSolve(String slug, List<Map<String, Object>> request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("api/v1/bulk-solve").addPathSegment(slug).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (List)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> parallelSolve(Map<String, Object> request) {
        return this.parallelSolve(request, null);
    }

    public Map<String, Object> parallelSolve(Map<String, Object> request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("api/v1/parallel-solve").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (Map)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<ListResponseItem> list() {
        return this.list(null);
    }

    public List<ListResponseItem> list(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("api/v1/list").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (List)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), (TypeReference)new TypeReference<List<ListResponseItem>>(){});
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public UsageResponse usage() {
        return this.usage(null);
    }

    public UsageResponse usage(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("api/v1/usage").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (UsageResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), UsageResponse.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

