/*
 * Decompiled with CFR 0.152.
 */
package resources.assets;

import com.fasterxml.jackson.core.type.TypeReference;
import core.ApiError;
import core.ClientOptions;
import core.MediaTypes;
import core.ObjectMappers;
import core.RequestOptions;
import java.io.IOException;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import resources.assets.requests.DeleteRuleRequest;
import resources.assets.requests.ExportRuleRequest;
import resources.assets.requests.ImportRuleRequest;
import resources.assets.types.DeleteRuleResponse;
import resources.assets.types.ImportRuleResponse;
import resources.assets.types.UsageResponse;

public class AssetsClient {
    protected final ClientOptions clientOptions;

    public AssetsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public DeleteRuleResponse deleteRule() {
        return this.deleteRule(DeleteRuleRequest.builder().build());
    }

    public DeleteRuleResponse deleteRule(DeleteRuleRequest request) {
        return this.deleteRule(request, null);
    }

    public DeleteRuleResponse deleteRule(DeleteRuleRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("api/v1/admin/rules/delete").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("DELETE", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (DeleteRuleResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), DeleteRuleResponse.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> exportRule(ExportRuleRequest request) {
        return this.exportRule(request, null);
    }

    public Map<String, Object> exportRule(ExportRuleRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("api/v1/admin/rules/export");
        httpUrl.addQueryParameter("id", request.getId());
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (Map)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ImportRuleResponse importRule(ImportRuleRequest request) {
        return this.importRule(request, null);
    }

    public ImportRuleResponse importRule(ImportRuleRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("api/v1/admin/rules/import").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (ImportRuleResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), ImportRuleResponse.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void list() {
        this.list(null);
    }

    public void list(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("api/v1/admin/flows/list").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return;
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public UsageResponse usage() {
        return this.usage(null);
    }

    public UsageResponse usage(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("api/v1/admin/usage").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (UsageResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), UsageResponse.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

