/*
 * Decompiled with CFR 0.152.
 */
package resources.tests;

import com.fasterxml.jackson.core.type.TypeReference;
import core.ApiError;
import core.ClientOptions;
import core.MediaTypes;
import core.ObjectMappers;
import core.RequestOptions;
import java.io.IOException;
import java.util.List;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import resources.tests.requests.CreateTestRequest;
import resources.tests.types.CreateTestResponse;
import resources.tests.types.DeleteTestResponse;
import resources.tests.types.ListTestsResponseItem;

public class TestsClient {
    protected final ClientOptions clientOptions;

    public TestsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public List<ListTestsResponseItem> listTests(String slug) {
        return this.listTests(slug, null);
    }

    public List<ListTestsResponseItem> listTests(String slug, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("api/v1/admin/flows").addPathSegment(slug).addPathSegments("tests").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (List)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), (TypeReference)new TypeReference<List<ListTestsResponseItem>>(){});
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CreateTestResponse createTest(String slug, CreateTestRequest request) {
        return this.createTest(slug, request, null);
    }

    public CreateTestResponse createTest(String slug, CreateTestRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("api/v1/admin/flows").addPathSegment(slug).addPathSegments("tests").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (CreateTestResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), CreateTestResponse.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DeleteTestResponse deleteTest(String slug, String testId) {
        return this.deleteTest(slug, testId, null);
    }

    public DeleteTestResponse deleteTest(String slug, String testId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("api/v1/admin/flows").addPathSegment(slug).addPathSegments("tests").addPathSegment(testId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (DeleteTestResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), DeleteTestResponse.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

