/*
 * Decompiled with CFR 0.152.
 */
package resources.values;

import com.fasterxml.jackson.core.type.TypeReference;
import core.ApiError;
import core.ClientOptions;
import core.MediaTypes;
import core.ObjectMappers;
import core.RequestOptions;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import resources.values.requests.DeleteDynamicValueRequest;
import resources.values.requests.ListDynamicValuesRequest;
import resources.values.types.DeleteDynamicValueResponse;
import resources.values.types.ListDynamicValuesResponseItem;
import resources.values.types.UpdateRequestValue;
import resources.values.types.UpdateResponseItem;

public class ValuesClient {
    protected final ClientOptions clientOptions;

    public ValuesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public List<ListDynamicValuesResponseItem> listDynamicValues() {
        return this.listDynamicValues(ListDynamicValuesRequest.builder().build());
    }

    public List<ListDynamicValuesResponseItem> listDynamicValues(ListDynamicValuesRequest request) {
        return this.listDynamicValues(request, null);
    }

    public List<ListDynamicValuesResponseItem> listDynamicValues(ListDynamicValuesRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("api/v1/values");
        if (request.getName().isPresent()) {
            httpUrl.addQueryParameter("name", request.getName().get());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (List)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), (TypeReference)new TypeReference<List<ListDynamicValuesResponseItem>>(){});
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<UpdateResponseItem> update(Map<String, UpdateRequestValue> request) {
        return this.update(request, null);
    }

    public List<UpdateResponseItem> update(Map<String, UpdateRequestValue> request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("api/v1/values").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (List)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), (TypeReference)new TypeReference<List<UpdateResponseItem>>(){});
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DeleteDynamicValueResponse deleteDynamicValue(DeleteDynamicValueRequest request) {
        return this.deleteDynamicValue(request, null);
    }

    public DeleteDynamicValueResponse deleteDynamicValue(DeleteDynamicValueRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("api/v1/values");
        httpUrl.addQueryParameter("id", request.getId());
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (DeleteDynamicValueResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), DeleteDynamicValueResponse.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

