/**
 * This file was auto-generated by Fern from our API Definition.
 */

package resources.assets;

import com.fasterxml.jackson.core.type.TypeReference;
import core.ApiError;
import core.ClientOptions;
import core.MediaTypes;
import core.ObjectMappers;
import core.RequestOptions;
import java.io.IOException;
import java.lang.Exception;
import java.lang.Object;
import java.lang.RuntimeException;
import java.lang.String;
import java.util.List;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import resources.assets.requests.DeleteRuleRequest;
import resources.assets.requests.ExportRuleRequest;
import resources.assets.requests.ImportRuleRequest;
import resources.assets.types.DeleteRuleResponse;
import resources.assets.types.ImportRuleResponse;
import resources.assets.types.ListRulesResponseItem;
import resources.assets.types.UsageResponse;

public class AssetsClient {
  protected final ClientOptions clientOptions;

  public AssetsClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
  }

  /**
   * Delete a specific rule by its ID.
   */
  public DeleteRuleResponse deleteRule() {
    return deleteRule(DeleteRuleRequest.builder().build());
  }

  /**
   * Delete a specific rule by its ID.
   */
  public DeleteRuleResponse deleteRule(DeleteRuleRequest request) {
    return deleteRule(request,null);
  }

  /**
   * Delete a specific rule by its ID.
   */
  public DeleteRuleResponse deleteRule(DeleteRuleRequest request, RequestOptions requestOptions) {
    HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("api/v1/admin/rules/delete")
      .build();
    RequestBody body;
    try {
      body = RequestBody.create(ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
    }
    catch(Exception e) {
      throw new RuntimeException(e);
    }
    Request okhttpRequest = new Request.Builder()
      .url(httpUrl)
      .method("DELETE", body)
      .headers(Headers.of(clientOptions.headers(requestOptions)))
      .addHeader("Content-Type", "application/json")
      .build();
    try {
      Response response = clientOptions.httpClient().newCall(okhttpRequest).execute();
      if (response.isSuccessful()) {
        return ObjectMappers.JSON_MAPPER.readValue(response.body().string(), DeleteRuleResponse.class);
      }
      throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
    }
    catch (IOException e) {
      throw new RuntimeException(e);
    }
  }

  /**
   * Export a specific rule by its ID.
   */
  public Map<String, Object> exportRule(ExportRuleRequest request) {
    return exportRule(request,null);
  }

  /**
   * Export a specific rule by its ID.
   */
  public Map<String, Object> exportRule(ExportRuleRequest request, RequestOptions requestOptions) {
    HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("api/v1/admin/rules/export");httpUrl.addQueryParameter("id", request.getId());
      Request.Builder _requestBuilder = new Request.Builder()
        .url(httpUrl.build())
        .method("GET", null)
        .headers(Headers.of(clientOptions.headers(requestOptions)))
        .addHeader("Content-Type", "application/json");
      Request okhttpRequest = _requestBuilder.build();
      try {
        Response response = clientOptions.httpClient().newCall(okhttpRequest).execute();
        if (response.isSuccessful()) {
          return ObjectMappers.JSON_MAPPER.readValue(response.body().string(), new TypeReference<Map<String, Object>>() {});
        }
        throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
      }
      catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    /**
     * Import a rule into the user's account.
     */
    public ImportRuleResponse importRule(ImportRuleRequest request) {
      return importRule(request,null);
    }

    /**
     * Import a rule into the user's account.
     */
    public ImportRuleResponse importRule(ImportRuleRequest request, RequestOptions requestOptions) {
      HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

        .addPathSegments("api/v1/admin/rules/import")
        .build();
      RequestBody body;
      try {
        body = RequestBody.create(ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
      }
      catch(Exception e) {
        throw new RuntimeException(e);
      }
      Request okhttpRequest = new Request.Builder()
        .url(httpUrl)
        .method("POST", body)
        .headers(Headers.of(clientOptions.headers(requestOptions)))
        .addHeader("Content-Type", "application/json")
        .build();
      try {
        Response response = clientOptions.httpClient().newCall(okhttpRequest).execute();
        if (response.isSuccessful()) {
          return ObjectMappers.JSON_MAPPER.readValue(response.body().string(), ImportRuleResponse.class);
        }
        throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
      }
      catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    /**
     * List all rules in the organization.
     */
    public List<ListRulesResponseItem> listRules() {
      return listRules(null);
    }

    /**
     * List all rules in the organization.
     */
    public List<ListRulesResponseItem> listRules(RequestOptions requestOptions) {
      HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

        .addPathSegments("api/v1/admin/rules/list")
        .build();
      Request okhttpRequest = new Request.Builder()
        .url(httpUrl)
        .method("GET", null)
        .headers(Headers.of(clientOptions.headers(requestOptions)))
        .addHeader("Content-Type", "application/json")
        .build();
      try {
        Response response = clientOptions.httpClient().newCall(okhttpRequest).execute();
        if (response.isSuccessful()) {
          return ObjectMappers.JSON_MAPPER.readValue(response.body().string(), new TypeReference<List<ListRulesResponseItem>>() {});
        }
        throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
      }
      catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    /**
     * List all flows in the organization.
     */
    public void listFlows() {
      listFlows(null);
    }

    /**
     * List all flows in the organization.
     */
    public void listFlows(RequestOptions requestOptions) {
      HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

        .addPathSegments("api/v1/admin/flows/list")
        .build();
      Request okhttpRequest = new Request.Builder()
        .url(httpUrl)
        .method("GET", null)
        .headers(Headers.of(clientOptions.headers(requestOptions)))
        .build();
      try {
        Response response = clientOptions.httpClient().newCall(okhttpRequest).execute();
        if (response.isSuccessful()) {
          return;
        }
        throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
      }
      catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    /**
     * Get the rule execution usage of your organization.
     */
    public UsageResponse usage() {
      return usage(null);
    }

    /**
     * Get the rule execution usage of your organization.
     */
    public UsageResponse usage(RequestOptions requestOptions) {
      HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

        .addPathSegments("api/v1/admin/usage")
        .build();
      Request okhttpRequest = new Request.Builder()
        .url(httpUrl)
        .method("GET", null)
        .headers(Headers.of(clientOptions.headers(requestOptions)))
        .addHeader("Content-Type", "application/json")
        .build();
      try {
        Response response = clientOptions.httpClient().newCall(okhttpRequest).execute();
        if (response.isSuccessful()) {
          return ObjectMappers.JSON_MAPPER.readValue(response.body().string(), UsageResponse.class);
        }
        throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
      }
      catch (IOException e) {
        throw new RuntimeException(e);
      }
    }
  }
