/**
 * This file was auto-generated by Fern from our API Definition.
 */

package resources.assets.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(
    builder = ListRulesResponseItem.Builder.class
)
public final class ListRulesResponseItem {
  private final Optional<String> id;

  private final Optional<String> name;

  private final Optional<String> description;

  private final Optional<Boolean> published;

  private final Optional<String> slug;

  private final Optional<String> updatedAt;

  private final Map<String, Object> additionalProperties;

  private ListRulesResponseItem(Optional<String> id, Optional<String> name,
      Optional<String> description, Optional<Boolean> published, Optional<String> slug,
      Optional<String> updatedAt, Map<String, Object> additionalProperties) {
    this.id = id;
    this.name = name;
    this.description = description;
    this.published = published;
    this.slug = slug;
    this.updatedAt = updatedAt;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The unique identifier for the rule.
   */
  @JsonProperty("id")
  public Optional<String> getId() {
    return id;
  }

  /**
   * @return The name of the rule.
   */
  @JsonProperty("name")
  public Optional<String> getName() {
    return name;
  }

  /**
   * @return The description of the rule.
   */
  @JsonProperty("description")
  public Optional<String> getDescription() {
    return description;
  }

  /**
   * @return Whether the rule is published.
   */
  @JsonProperty("published")
  public Optional<Boolean> getPublished() {
    return published;
  }

  /**
   * @return The unique slug for the rule used in API requests.
   */
  @JsonProperty("slug")
  public Optional<String> getSlug() {
    return slug;
  }

  /**
   * @return The date this rule was last updated.
   */
  @JsonProperty("updated_at")
  public Optional<String> getUpdatedAt() {
    return updatedAt;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ListRulesResponseItem && equalTo((ListRulesResponseItem) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ListRulesResponseItem other) {
    return id.equals(other.id) && name.equals(other.name) && description.equals(other.description) && published.equals(other.published) && slug.equals(other.slug) && updatedAt.equals(other.updatedAt);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id, this.name, this.description, this.published, this.slug, this.updatedAt);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> id = Optional.empty();

    private Optional<String> name = Optional.empty();

    private Optional<String> description = Optional.empty();

    private Optional<Boolean> published = Optional.empty();

    private Optional<String> slug = Optional.empty();

    private Optional<String> updatedAt = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(ListRulesResponseItem other) {
      id(other.getId());
      name(other.getName());
      description(other.getDescription());
      published(other.getPublished());
      slug(other.getSlug());
      updatedAt(other.getUpdatedAt());
      return this;
    }

    @JsonSetter(
        value = "id",
        nulls = Nulls.SKIP
    )
    public Builder id(Optional<String> id) {
      this.id = id;
      return this;
    }

    public Builder id(String id) {
      this.id = Optional.of(id);
      return this;
    }

    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public Builder name(Optional<String> name) {
      this.name = name;
      return this;
    }

    public Builder name(String name) {
      this.name = Optional.of(name);
      return this;
    }

    @JsonSetter(
        value = "description",
        nulls = Nulls.SKIP
    )
    public Builder description(Optional<String> description) {
      this.description = description;
      return this;
    }

    public Builder description(String description) {
      this.description = Optional.of(description);
      return this;
    }

    @JsonSetter(
        value = "published",
        nulls = Nulls.SKIP
    )
    public Builder published(Optional<Boolean> published) {
      this.published = published;
      return this;
    }

    public Builder published(Boolean published) {
      this.published = Optional.of(published);
      return this;
    }

    @JsonSetter(
        value = "slug",
        nulls = Nulls.SKIP
    )
    public Builder slug(Optional<String> slug) {
      this.slug = slug;
      return this;
    }

    public Builder slug(String slug) {
      this.slug = Optional.of(slug);
      return this;
    }

    @JsonSetter(
        value = "updated_at",
        nulls = Nulls.SKIP
    )
    public Builder updatedAt(Optional<String> updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    public Builder updatedAt(String updatedAt) {
      this.updatedAt = Optional.of(updatedAt);
      return this;
    }

    public ListRulesResponseItem build() {
      return new ListRulesResponseItem(id, name, description, published, slug, updatedAt, additionalProperties);
    }
  }
}
