/**
 * This file was auto-generated by Fern from our API Definition.
 */

package resources.decisions;

import core.ApiError;
import core.ClientOptions;
import core.ObjectMappers;
import core.RequestOptions;
import java.io.IOException;
import java.lang.Object;
import java.lang.RuntimeException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import resources.decisions.requests.QueryRequest;
import resources.decisions.types.QueryResponse;

public class DecisionsClient {
  protected final ClientOptions clientOptions;

  public DecisionsClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
  }

  /**
   * Retrieve logs for a specific user and rule, with optional date range and pagination.
   */
  public QueryResponse query(QueryRequest request) {
    return query(request,null);
  }

  /**
   * Retrieve logs for a specific user and rule, with optional date range and pagination.
   */
  public QueryResponse query(QueryRequest request, RequestOptions requestOptions) {
    HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("api/v1/decisions/query");httpUrl.addQueryParameter("slug", request.getSlug());
      if (request.getFrom().isPresent()) {
        httpUrl.addQueryParameter("from", request.getFrom().get().toString());
      }
      if (request.getTo().isPresent()) {
        httpUrl.addQueryParameter("to", request.getTo().get().toString());
      }
      if (request.getCursor().isPresent()) {
        httpUrl.addQueryParameter("cursor", request.getCursor().get());
      }
      if (request.getLimit().isPresent()) {
        httpUrl.addQueryParameter("limit", request.getLimit().get().toString());
      }
      Request.Builder _requestBuilder = new Request.Builder()
        .url(httpUrl.build())
        .method("GET", null)
        .headers(Headers.of(clientOptions.headers(requestOptions)))
        .addHeader("Content-Type", "application/json");
      Request okhttpRequest = _requestBuilder.build();
      try {
        Response response = clientOptions.httpClient().newCall(okhttpRequest).execute();
        if (response.isSuccessful()) {
          return ObjectMappers.JSON_MAPPER.readValue(response.body().string(), QueryResponse.class);
        }
        throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
      }
      catch (IOException e) {
        throw new RuntimeException(e);
      }
    }
  }
