/**
 * This file was auto-generated by Fern from our API Definition.
 */

package resources.decisions.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(
    builder = QueryResponse.Builder.class
)
public final class QueryResponse {
  private final Optional<List<Map<String, Object>>> data;

  private final Optional<String> cursor;

  private final Map<String, Object> additionalProperties;

  private QueryResponse(Optional<List<Map<String, Object>>> data, Optional<String> cursor,
      Map<String, Object> additionalProperties) {
    this.data = data;
    this.cursor = cursor;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("data")
  public Optional<List<Map<String, Object>>> getData() {
    return data;
  }

  @JsonProperty("cursor")
  public Optional<String> getCursor() {
    return cursor;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof QueryResponse && equalTo((QueryResponse) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(QueryResponse other) {
    return data.equals(other.data) && cursor.equals(other.cursor);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.data, this.cursor);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<List<Map<String, Object>>> data = Optional.empty();

    private Optional<String> cursor = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(QueryResponse other) {
      data(other.getData());
      cursor(other.getCursor());
      return this;
    }

    @JsonSetter(
        value = "data",
        nulls = Nulls.SKIP
    )
    public Builder data(Optional<List<Map<String, Object>>> data) {
      this.data = data;
      return this;
    }

    public Builder data(List<Map<String, Object>> data) {
      this.data = Optional.of(data);
      return this;
    }

    @JsonSetter(
        value = "cursor",
        nulls = Nulls.SKIP
    )
    public Builder cursor(Optional<String> cursor) {
      this.cursor = cursor;
      return this;
    }

    public Builder cursor(String cursor) {
      this.cursor = Optional.of(cursor);
      return this;
    }

    public QueryResponse build() {
      return new QueryResponse(data, cursor, additionalProperties);
    }
  }
}
