/**
 * This file was auto-generated by Fern from our API Definition.
 */

package resources.users.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import resources.users.types.InviteRequestRole;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(
    builder = InviteRequest.Builder.class
)
public final class InviteRequest {
  private final String email;

  private final Optional<InviteRequestRole> role;

  private final Optional<List<String>> accessGroups;

  private final Map<String, Object> additionalProperties;

  private InviteRequest(String email, Optional<InviteRequestRole> role,
      Optional<List<String>> accessGroups, Map<String, Object> additionalProperties) {
    this.email = email;
    this.role = role;
    this.accessGroups = accessGroups;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Email of the user to invite.
   */
  @JsonProperty("email")
  public String getEmail() {
    return email;
  }

  /**
   * @return Role to assign to the user.
   */
  @JsonProperty("role")
  public Optional<InviteRequestRole> getRole() {
    return role;
  }

  /**
   * @return List of access group names or IDs to assign to the user.
   */
  @JsonProperty("accessGroups")
  public Optional<List<String>> getAccessGroups() {
    return accessGroups;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof InviteRequest && equalTo((InviteRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(InviteRequest other) {
    return email.equals(other.email) && role.equals(other.role) && accessGroups.equals(other.accessGroups);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.email, this.role, this.accessGroups);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static EmailStage builder() {
    return new Builder();
  }

  public interface EmailStage {
    _FinalStage email(String email);

    Builder from(InviteRequest other);
  }

  public interface _FinalStage {
    InviteRequest build();

    _FinalStage role(Optional<InviteRequestRole> role);

    _FinalStage role(InviteRequestRole role);

    _FinalStage accessGroups(Optional<List<String>> accessGroups);

    _FinalStage accessGroups(List<String> accessGroups);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements EmailStage, _FinalStage {
    private String email;

    private Optional<List<String>> accessGroups = Optional.empty();

    private Optional<InviteRequestRole> role = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(InviteRequest other) {
      email(other.getEmail());
      role(other.getRole());
      accessGroups(other.getAccessGroups());
      return this;
    }

    /**
     * <p>Email of the user to invite.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("email")
    public _FinalStage email(String email) {
      this.email = email;
      return this;
    }

    /**
     * <p>List of access group names or IDs to assign to the user.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage accessGroups(List<String> accessGroups) {
      this.accessGroups = Optional.of(accessGroups);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "accessGroups",
        nulls = Nulls.SKIP
    )
    public _FinalStage accessGroups(Optional<List<String>> accessGroups) {
      this.accessGroups = accessGroups;
      return this;
    }

    /**
     * <p>Role to assign to the user.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage role(InviteRequestRole role) {
      this.role = Optional.of(role);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "role",
        nulls = Nulls.SKIP
    )
    public _FinalStage role(Optional<InviteRequestRole> role) {
      this.role = role;
      return this;
    }

    @java.lang.Override
    public InviteRequest build() {
      return new InviteRequest(email, role, accessGroups, additionalProperties);
    }
  }
}
