/**
 * This file was auto-generated by Fern from our API Definition.
 */

package resources.values;

import com.fasterxml.jackson.core.type.TypeReference;
import core.ApiError;
import core.ClientOptions;
import core.MediaTypes;
import core.ObjectMappers;
import core.RequestOptions;
import java.io.IOException;
import java.lang.Exception;
import java.lang.Object;
import java.lang.RuntimeException;
import java.lang.String;
import java.util.List;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import resources.values.requests.DeleteDynamicValueRequest;
import resources.values.requests.ListDynamicValuesRequest;
import resources.values.types.DeleteDynamicValueResponse;
import resources.values.types.ListDynamicValuesResponseItem;
import resources.values.types.UpdateRequestValue;
import resources.values.types.UpdateResponseItem;

public class ValuesClient {
  protected final ClientOptions clientOptions;

  public ValuesClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
  }

  /**
   * Retrieve all dynamic values for the authenticated user.
   */
  public List<ListDynamicValuesResponseItem> listDynamicValues() {
    return listDynamicValues(ListDynamicValuesRequest.builder().build());
  }

  /**
   * Retrieve all dynamic values for the authenticated user.
   */
  public List<ListDynamicValuesResponseItem> listDynamicValues(ListDynamicValuesRequest request) {
    return listDynamicValues(request,null);
  }

  /**
   * Retrieve all dynamic values for the authenticated user.
   */
  public List<ListDynamicValuesResponseItem> listDynamicValues(ListDynamicValuesRequest request,
      RequestOptions requestOptions) {
    HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("api/v1/values");if (request.getName().isPresent()) {
        httpUrl.addQueryParameter("name", request.getName().get());
      }
      Request.Builder _requestBuilder = new Request.Builder()
        .url(httpUrl.build())
        .method("GET", null)
        .headers(Headers.of(clientOptions.headers(requestOptions)))
        .addHeader("Content-Type", "application/json");
      Request okhttpRequest = _requestBuilder.build();
      try {
        Response response = clientOptions.httpClient().newCall(okhttpRequest).execute();
        if (response.isSuccessful()) {
          return ObjectMappers.JSON_MAPPER.readValue(response.body().string(), new TypeReference<List<ListDynamicValuesResponseItem>>() {});
        }
        throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
      }
      catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    /**
     * Update existing dynamic values or add new ones for the authenticated user.
     */
    public List<UpdateResponseItem> update(Map<String, UpdateRequestValue> request) {
      return update(request,null);
    }

    /**
     * Update existing dynamic values or add new ones for the authenticated user.
     */
    public List<UpdateResponseItem> update(Map<String, UpdateRequestValue> request,
        RequestOptions requestOptions) {
      HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

        .addPathSegments("api/v1/values")
        .build();
      RequestBody body;
      try {
        body = RequestBody.create(ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
      }
      catch(Exception e) {
        throw new RuntimeException(e);
      }
      Request okhttpRequest = new Request.Builder()
        .url(httpUrl)
        .method("POST", body)
        .headers(Headers.of(clientOptions.headers(requestOptions)))
        .addHeader("Content-Type", "application/json")
        .build();
      try {
        Response response = clientOptions.httpClient().newCall(okhttpRequest).execute();
        if (response.isSuccessful()) {
          return ObjectMappers.JSON_MAPPER.readValue(response.body().string(), new TypeReference<List<UpdateResponseItem>>() {});
        }
        throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
      }
      catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    /**
     * Delete a specific dynamic value for the authenticated user by its ID.
     */
    public DeleteDynamicValueResponse deleteDynamicValue(DeleteDynamicValueRequest request) {
      return deleteDynamicValue(request,null);
    }

    /**
     * Delete a specific dynamic value for the authenticated user by its ID.
     */
    public DeleteDynamicValueResponse deleteDynamicValue(DeleteDynamicValueRequest request,
        RequestOptions requestOptions) {
      HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

        .addPathSegments("api/v1/values");httpUrl.addQueryParameter("id", request.getId());
        Request.Builder _requestBuilder = new Request.Builder()
          .url(httpUrl.build())
          .method("DELETE", null)
          .headers(Headers.of(clientOptions.headers(requestOptions)))
          .addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        try {
          Response response = clientOptions.httpClient().newCall(okhttpRequest).execute();
          if (response.isSuccessful()) {
            return ObjectMappers.JSON_MAPPER.readValue(response.body().string(), DeleteDynamicValueResponse.class);
          }
          throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
          throw new RuntimeException(e);
        }
      }
    }
