/*
 * Decompiled with CFR 0.152.
 */
package resources.values.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import resources.values.types.UpdateResponseItemType;
import resources.values.types.UpdateResponseItemValue;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class UpdateResponseItem {
    private final Optional<String> id;
    private final Optional<String> name;
    private final Optional<UpdateResponseItemType> type;
    private final Optional<UpdateResponseItemValue> value;
    private final Map<String, Object> additionalProperties;

    private UpdateResponseItem(Optional<String> id, Optional<String> name, Optional<UpdateResponseItemType> type, Optional<UpdateResponseItemValue> value, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.value = value;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="type")
    public Optional<UpdateResponseItemType> getType() {
        return this.type;
    }

    @JsonProperty(value="value")
    public Optional<UpdateResponseItemValue> getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateResponseItem && this.equalTo((UpdateResponseItem)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateResponseItem other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.type.equals(other.type) && this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.type, this.value);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<UpdateResponseItemType> type = Optional.empty();
        private Optional<UpdateResponseItemValue> value = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(UpdateResponseItem other) {
            this.id(other.getId());
            this.name(other.getName());
            this.type(other.getType());
            this.value(other.getValue());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<UpdateResponseItemType> type) {
            this.type = type;
            return this;
        }

        public Builder type(UpdateResponseItemType type) {
            this.type = Optional.of(type);
            return this;
        }

        @JsonSetter(value="value", nulls=Nulls.SKIP)
        public Builder value(Optional<UpdateResponseItemValue> value) {
            this.value = value;
            return this;
        }

        public Builder value(UpdateResponseItemValue value) {
            this.value = Optional.of(value);
            return this;
        }

        public UpdateResponseItem build() {
            return new UpdateResponseItem(this.id, this.name, this.type, this.value, this.additionalProperties);
        }
    }
}

