/**
 * This file was auto-generated by Fern from our API Definition.
 */

package resources.tests;

import com.fasterxml.jackson.core.type.TypeReference;
import core.ApiError;
import core.ClientOptions;
import core.MediaTypes;
import core.ObjectMappers;
import core.RequestOptions;
import java.io.IOException;
import java.lang.Exception;
import java.lang.Object;
import java.lang.RuntimeException;
import java.lang.String;
import java.util.List;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import resources.tests.requests.CreateFlowTestRequest;
import resources.tests.requests.CreateRuleTestRequest;
import resources.tests.types.CreateFlowTestResponse;
import resources.tests.types.CreateRuleTestResponse;
import resources.tests.types.DeleteFlowTestResponse;
import resources.tests.types.DeleteRuleTestResponse;
import resources.tests.types.ListFlowTestsResponseItem;
import resources.tests.types.ListRuleTestsResponseItem;

public class TestsClient {
  protected final ClientOptions clientOptions;

  public TestsClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
  }

  /**
   * Retrieves a list of tests associated with the rule identified by the slug.
   */
  public List<ListRuleTestsResponseItem> listRuleTests(String slug) {
    return listRuleTests(slug,null);
  }

  /**
   * Retrieves a list of tests associated with the rule identified by the slug.
   */
  public List<ListRuleTestsResponseItem> listRuleTests(String slug, RequestOptions requestOptions) {
    HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("api/v1/admin/rules")
      .addPathSegment(slug)
      .addPathSegments("tests")
      .build();
    Request okhttpRequest = new Request.Builder()
      .url(httpUrl)
      .method("GET", null)
      .headers(Headers.of(clientOptions.headers(requestOptions)))
      .addHeader("Content-Type", "application/json")
      .build();
    try {
      Response response = clientOptions.httpClient().newCall(okhttpRequest).execute();
      if (response.isSuccessful()) {
        return ObjectMappers.JSON_MAPPER.readValue(response.body().string(), new TypeReference<List<ListRuleTestsResponseItem>>() {});
      }
      throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
    }
    catch (IOException e) {
      throw new RuntimeException(e);
    }
  }

  /**
   * Adds a new test to the test suite of a rule identified by the slug.
   */
  public CreateRuleTestResponse createRuleTest(String slug, CreateRuleTestRequest request) {
    return createRuleTest(slug,request,null);
  }

  /**
   * Adds a new test to the test suite of a rule identified by the slug.
   */
  public CreateRuleTestResponse createRuleTest(String slug, CreateRuleTestRequest request,
      RequestOptions requestOptions) {
    HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("api/v1/admin/rules")
      .addPathSegment(slug)
      .addPathSegments("tests")
      .build();
    RequestBody body;
    try {
      body = RequestBody.create(ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
    }
    catch(Exception e) {
      throw new RuntimeException(e);
    }
    Request okhttpRequest = new Request.Builder()
      .url(httpUrl)
      .method("POST", body)
      .headers(Headers.of(clientOptions.headers(requestOptions)))
      .addHeader("Content-Type", "application/json")
      .build();
    try {
      Response response = clientOptions.httpClient().newCall(okhttpRequest).execute();
      if (response.isSuccessful()) {
        return ObjectMappers.JSON_MAPPER.readValue(response.body().string(), CreateRuleTestResponse.class);
      }
      throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
    }
    catch (IOException e) {
      throw new RuntimeException(e);
    }
  }

  /**
   * Deletes a test from the test suite of a rule identified by the slug.
   */
  public DeleteRuleTestResponse deleteRuleTest(String slug, String testId) {
    return deleteRuleTest(slug,testId,null);
  }

  /**
   * Deletes a test from the test suite of a rule identified by the slug.
   */
  public DeleteRuleTestResponse deleteRuleTest(String slug, String testId,
      RequestOptions requestOptions) {
    HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("api/v1/admin/rules")
      .addPathSegment(slug)
      .addPathSegments("tests")
      .addPathSegment(testId)
      .build();
    Request okhttpRequest = new Request.Builder()
      .url(httpUrl)
      .method("DELETE", null)
      .headers(Headers.of(clientOptions.headers(requestOptions)))
      .addHeader("Content-Type", "application/json")
      .build();
    try {
      Response response = clientOptions.httpClient().newCall(okhttpRequest).execute();
      if (response.isSuccessful()) {
        return ObjectMappers.JSON_MAPPER.readValue(response.body().string(), DeleteRuleTestResponse.class);
      }
      throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
    }
    catch (IOException e) {
      throw new RuntimeException(e);
    }
  }

  /**
   * Retrieves a list of tests associated with the flow identified by the slug.
   */
  public List<ListFlowTestsResponseItem> listFlowTests(String slug) {
    return listFlowTests(slug,null);
  }

  /**
   * Retrieves a list of tests associated with the flow identified by the slug.
   */
  public List<ListFlowTestsResponseItem> listFlowTests(String slug, RequestOptions requestOptions) {
    HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("api/v1/admin/flows")
      .addPathSegment(slug)
      .addPathSegments("tests")
      .build();
    Request okhttpRequest = new Request.Builder()
      .url(httpUrl)
      .method("GET", null)
      .headers(Headers.of(clientOptions.headers(requestOptions)))
      .addHeader("Content-Type", "application/json")
      .build();
    try {
      Response response = clientOptions.httpClient().newCall(okhttpRequest).execute();
      if (response.isSuccessful()) {
        return ObjectMappers.JSON_MAPPER.readValue(response.body().string(), new TypeReference<List<ListFlowTestsResponseItem>>() {});
      }
      throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
    }
    catch (IOException e) {
      throw new RuntimeException(e);
    }
  }

  /**
   * Adds a new test to the test suite of a flow identified by the slug.
   */
  public CreateFlowTestResponse createFlowTest(String slug, CreateFlowTestRequest request) {
    return createFlowTest(slug,request,null);
  }

  /**
   * Adds a new test to the test suite of a flow identified by the slug.
   */
  public CreateFlowTestResponse createFlowTest(String slug, CreateFlowTestRequest request,
      RequestOptions requestOptions) {
    HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("api/v1/admin/flows")
      .addPathSegment(slug)
      .addPathSegments("tests")
      .build();
    RequestBody body;
    try {
      body = RequestBody.create(ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
    }
    catch(Exception e) {
      throw new RuntimeException(e);
    }
    Request okhttpRequest = new Request.Builder()
      .url(httpUrl)
      .method("POST", body)
      .headers(Headers.of(clientOptions.headers(requestOptions)))
      .addHeader("Content-Type", "application/json")
      .build();
    try {
      Response response = clientOptions.httpClient().newCall(okhttpRequest).execute();
      if (response.isSuccessful()) {
        return ObjectMappers.JSON_MAPPER.readValue(response.body().string(), CreateFlowTestResponse.class);
      }
      throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
    }
    catch (IOException e) {
      throw new RuntimeException(e);
    }
  }

  /**
   * Deletes a test from the test suite of a flow identified by the slug.
   */
  public DeleteFlowTestResponse deleteFlowTest(String slug, String testId) {
    return deleteFlowTest(slug,testId,null);
  }

  /**
   * Deletes a test from the test suite of a flow identified by the slug.
   */
  public DeleteFlowTestResponse deleteFlowTest(String slug, String testId,
      RequestOptions requestOptions) {
    HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("api/v1/admin/flows")
      .addPathSegment(slug)
      .addPathSegments("tests")
      .addPathSegment(testId)
      .build();
    Request okhttpRequest = new Request.Builder()
      .url(httpUrl)
      .method("DELETE", null)
      .headers(Headers.of(clientOptions.headers(requestOptions)))
      .addHeader("Content-Type", "application/json")
      .build();
    try {
      Response response = clientOptions.httpClient().newCall(okhttpRequest).execute();
      if (response.isSuccessful()) {
        return ObjectMappers.JSON_MAPPER.readValue(response.body().string(), DeleteFlowTestResponse.class);
      }
      throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
    }
    catch (IOException e) {
      throw new RuntimeException(e);
    }
  }
}
