/*
 * Decompiled with CFR 0.152.
 */
package resources.assets.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ImportRuleRequest {
    private final String id;
    private final OffsetDateTime createdAt;
    private final String slug;
    private final OffsetDateTime updatedAt;
    private final Map<String, Object> testRequest;
    private final String name;
    private final String description;
    private final List<Object> requestSchema;
    private final List<Object> responseSchema;
    private final Map<String, Object> sampleRequest;
    private final Map<String, Object> sampleResponse;
    private final List<Object> conditions;
    private final boolean published;
    private final List<Object> history;
    private final Map<String, Object> additionalProperties;

    private ImportRuleRequest(String id, OffsetDateTime createdAt, String slug, OffsetDateTime updatedAt, Map<String, Object> testRequest, String name, String description, List<Object> requestSchema, List<Object> responseSchema, Map<String, Object> sampleRequest, Map<String, Object> sampleResponse, List<Object> conditions, boolean published, List<Object> history, Map<String, Object> additionalProperties) {
        this.id = id;
        this.createdAt = createdAt;
        this.slug = slug;
        this.updatedAt = updatedAt;
        this.testRequest = testRequest;
        this.name = name;
        this.description = description;
        this.requestSchema = requestSchema;
        this.responseSchema = responseSchema;
        this.sampleRequest = sampleRequest;
        this.sampleResponse = sampleResponse;
        this.conditions = conditions;
        this.published = published;
        this.history = history;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="createdAt")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="slug")
    public String getSlug() {
        return this.slug;
    }

    @JsonProperty(value="updatedAt")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="testRequest")
    public Map<String, Object> getTestRequest() {
        return this.testRequest;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="requestSchema")
    public List<Object> getRequestSchema() {
        return this.requestSchema;
    }

    @JsonProperty(value="responseSchema")
    public List<Object> getResponseSchema() {
        return this.responseSchema;
    }

    @JsonProperty(value="sampleRequest")
    public Map<String, Object> getSampleRequest() {
        return this.sampleRequest;
    }

    @JsonProperty(value="sampleResponse")
    public Map<String, Object> getSampleResponse() {
        return this.sampleResponse;
    }

    @JsonProperty(value="conditions")
    public List<Object> getConditions() {
        return this.conditions;
    }

    @JsonProperty(value="published")
    public boolean getPublished() {
        return this.published;
    }

    @JsonProperty(value="history")
    public List<Object> getHistory() {
        return this.history;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ImportRuleRequest && this.equalTo((ImportRuleRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ImportRuleRequest other) {
        return this.id.equals(other.id) && this.createdAt.equals(other.createdAt) && this.slug.equals(other.slug) && this.updatedAt.equals(other.updatedAt) && this.testRequest.equals(other.testRequest) && this.name.equals(other.name) && this.description.equals(other.description) && this.requestSchema.equals(other.requestSchema) && this.responseSchema.equals(other.responseSchema) && this.sampleRequest.equals(other.sampleRequest) && this.sampleResponse.equals(other.sampleResponse) && this.conditions.equals(other.conditions) && this.published == other.published && this.history.equals(other.history);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdAt, this.slug, this.updatedAt, this.testRequest, this.name, this.description, this.requestSchema, this.responseSchema, this.sampleRequest, this.sampleResponse, this.conditions, this.published, this.history);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    CreatedAtStage,
    SlugStage,
    UpdatedAtStage,
    NameStage,
    DescriptionStage,
    PublishedStage,
    _FinalStage {
        private String id;
        private OffsetDateTime createdAt;
        private String slug;
        private OffsetDateTime updatedAt;
        private String name;
        private String description;
        private boolean published;
        private List<Object> history = new ArrayList<Object>();
        private List<Object> conditions = new ArrayList<Object>();
        private Map<String, Object> sampleResponse = new LinkedHashMap<String, Object>();
        private Map<String, Object> sampleRequest = new LinkedHashMap<String, Object>();
        private List<Object> responseSchema = new ArrayList<Object>();
        private List<Object> requestSchema = new ArrayList<Object>();
        private Map<String, Object> testRequest = new LinkedHashMap<String, Object>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ImportRuleRequest other) {
            this.id(other.getId());
            this.createdAt(other.getCreatedAt());
            this.slug(other.getSlug());
            this.updatedAt(other.getUpdatedAt());
            this.testRequest(other.getTestRequest());
            this.name(other.getName());
            this.description(other.getDescription());
            this.requestSchema(other.getRequestSchema());
            this.responseSchema(other.getResponseSchema());
            this.sampleRequest(other.getSampleRequest());
            this.sampleResponse(other.getSampleResponse());
            this.conditions(other.getConditions());
            this.published(other.getPublished());
            this.history(other.getHistory());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public CreatedAtStage id(String id) {
            this.id = id;
            return this;
        }

        @Override
        @JsonSetter(value="createdAt")
        public SlugStage createdAt(OffsetDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        @JsonSetter(value="slug")
        public UpdatedAtStage slug(String slug) {
            this.slug = slug;
            return this;
        }

        @Override
        @JsonSetter(value="updatedAt")
        public NameStage updatedAt(OffsetDateTime updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public DescriptionStage name(String name) {
            this.name = name;
            return this;
        }

        @Override
        @JsonSetter(value="description")
        public PublishedStage description(String description) {
            this.description = description;
            return this;
        }

        @Override
        @JsonSetter(value="published")
        public _FinalStage published(boolean published) {
            this.published = published;
            return this;
        }

        @Override
        public _FinalStage addAllHistory(List<Object> history) {
            this.history.addAll(history);
            return this;
        }

        @Override
        public _FinalStage addHistory(Object history) {
            this.history.add(history);
            return this;
        }

        @Override
        @JsonSetter(value="history", nulls=Nulls.SKIP)
        public _FinalStage history(List<Object> history) {
            this.history.clear();
            this.history.addAll(history);
            return this;
        }

        @Override
        public _FinalStage addAllConditions(List<Object> conditions) {
            this.conditions.addAll(conditions);
            return this;
        }

        @Override
        public _FinalStage addConditions(Object conditions) {
            this.conditions.add(conditions);
            return this;
        }

        @Override
        @JsonSetter(value="conditions", nulls=Nulls.SKIP)
        public _FinalStage conditions(List<Object> conditions) {
            this.conditions.clear();
            this.conditions.addAll(conditions);
            return this;
        }

        @Override
        public _FinalStage sampleResponse(String key, Object value) {
            this.sampleResponse.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllSampleResponse(Map<String, Object> sampleResponse) {
            this.sampleResponse.putAll(sampleResponse);
            return this;
        }

        @Override
        @JsonSetter(value="sampleResponse", nulls=Nulls.SKIP)
        public _FinalStage sampleResponse(Map<String, Object> sampleResponse) {
            this.sampleResponse.clear();
            this.sampleResponse.putAll(sampleResponse);
            return this;
        }

        @Override
        public _FinalStage sampleRequest(String key, Object value) {
            this.sampleRequest.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllSampleRequest(Map<String, Object> sampleRequest) {
            this.sampleRequest.putAll(sampleRequest);
            return this;
        }

        @Override
        @JsonSetter(value="sampleRequest", nulls=Nulls.SKIP)
        public _FinalStage sampleRequest(Map<String, Object> sampleRequest) {
            this.sampleRequest.clear();
            this.sampleRequest.putAll(sampleRequest);
            return this;
        }

        @Override
        public _FinalStage addAllResponseSchema(List<Object> responseSchema) {
            this.responseSchema.addAll(responseSchema);
            return this;
        }

        @Override
        public _FinalStage addResponseSchema(Object responseSchema) {
            this.responseSchema.add(responseSchema);
            return this;
        }

        @Override
        @JsonSetter(value="responseSchema", nulls=Nulls.SKIP)
        public _FinalStage responseSchema(List<Object> responseSchema) {
            this.responseSchema.clear();
            this.responseSchema.addAll(responseSchema);
            return this;
        }

        @Override
        public _FinalStage addAllRequestSchema(List<Object> requestSchema) {
            this.requestSchema.addAll(requestSchema);
            return this;
        }

        @Override
        public _FinalStage addRequestSchema(Object requestSchema) {
            this.requestSchema.add(requestSchema);
            return this;
        }

        @Override
        @JsonSetter(value="requestSchema", nulls=Nulls.SKIP)
        public _FinalStage requestSchema(List<Object> requestSchema) {
            this.requestSchema.clear();
            this.requestSchema.addAll(requestSchema);
            return this;
        }

        @Override
        public _FinalStage testRequest(String key, Object value) {
            this.testRequest.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllTestRequest(Map<String, Object> testRequest) {
            this.testRequest.putAll(testRequest);
            return this;
        }

        @Override
        @JsonSetter(value="testRequest", nulls=Nulls.SKIP)
        public _FinalStage testRequest(Map<String, Object> testRequest) {
            this.testRequest.clear();
            this.testRequest.putAll(testRequest);
            return this;
        }

        @Override
        public ImportRuleRequest build() {
            return new ImportRuleRequest(this.id, this.createdAt, this.slug, this.updatedAt, this.testRequest, this.name, this.description, this.requestSchema, this.responseSchema, this.sampleRequest, this.sampleResponse, this.conditions, this.published, this.history, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ImportRuleRequest build();

        public _FinalStage testRequest(Map<String, Object> var1);

        public _FinalStage putAllTestRequest(Map<String, Object> var1);

        public _FinalStage testRequest(String var1, Object var2);

        public _FinalStage requestSchema(List<Object> var1);

        public _FinalStage addRequestSchema(Object var1);

        public _FinalStage addAllRequestSchema(List<Object> var1);

        public _FinalStage responseSchema(List<Object> var1);

        public _FinalStage addResponseSchema(Object var1);

        public _FinalStage addAllResponseSchema(List<Object> var1);

        public _FinalStage sampleRequest(Map<String, Object> var1);

        public _FinalStage putAllSampleRequest(Map<String, Object> var1);

        public _FinalStage sampleRequest(String var1, Object var2);

        public _FinalStage sampleResponse(Map<String, Object> var1);

        public _FinalStage putAllSampleResponse(Map<String, Object> var1);

        public _FinalStage sampleResponse(String var1, Object var2);

        public _FinalStage conditions(List<Object> var1);

        public _FinalStage addConditions(Object var1);

        public _FinalStage addAllConditions(List<Object> var1);

        public _FinalStage history(List<Object> var1);

        public _FinalStage addHistory(Object var1);

        public _FinalStage addAllHistory(List<Object> var1);
    }

    public static interface PublishedStage {
        public _FinalStage published(boolean var1);
    }

    public static interface DescriptionStage {
        public PublishedStage description(String var1);
    }

    public static interface NameStage {
        public DescriptionStage name(String var1);
    }

    public static interface UpdatedAtStage {
        public NameStage updatedAt(OffsetDateTime var1);
    }

    public static interface SlugStage {
        public UpdatedAtStage slug(String var1);
    }

    public static interface CreatedAtStage {
        public SlugStage createdAt(OffsetDateTime var1);
    }

    public static interface IdStage {
        public CreatedAtStage id(String var1);

        public Builder from(ImportRuleRequest var1);
    }
}

