/*
 * Decompiled with CFR 0.152.
 */
package resources.values.types;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import core.ObjectMappers;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(using=Deserializer.class)
public final class ListDynamicValuesResponseItemValue {
    private final Object value;
    private final int type;

    private ListDynamicValuesResponseItemValue(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((String)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((Double)this.value);
        }
        if (this.type == 2) {
            return visitor.visit((Boolean)this.value);
        }
        if (this.type == 3) {
            return visitor.visit((List)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListDynamicValuesResponseItemValue && this.equalTo((ListDynamicValuesResponseItemValue)other);
    }

    private boolean equalTo(ListDynamicValuesResponseItemValue other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static ListDynamicValuesResponseItemValue of(String value) {
        return new ListDynamicValuesResponseItemValue(value, 0);
    }

    public static ListDynamicValuesResponseItemValue of(double value) {
        return new ListDynamicValuesResponseItemValue(value, 1);
    }

    public static ListDynamicValuesResponseItemValue of(boolean value) {
        return new ListDynamicValuesResponseItemValue(value, 2);
    }

    public static ListDynamicValuesResponseItemValue of(List<Object> value) {
        return new ListDynamicValuesResponseItemValue(value, 3);
    }

    static final class Deserializer
    extends StdDeserializer<ListDynamicValuesResponseItemValue> {
        Deserializer() {
            super(ListDynamicValuesResponseItemValue.class);
        }

        public ListDynamicValuesResponseItemValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return ListDynamicValuesResponseItemValue.of((String)ObjectMappers.JSON_MAPPER.convertValue(value, String.class));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (value instanceof Double) {
                    return ListDynamicValuesResponseItemValue.of((Double)value);
                }
                if (value instanceof Boolean) {
                    return ListDynamicValuesResponseItemValue.of((Boolean)value);
                }
                try {
                    return ListDynamicValuesResponseItemValue.of((List)ObjectMappers.JSON_MAPPER.convertValue(value, (TypeReference)new TypeReference<List<Object>>(){}));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    throw new JsonParseException(p, "Failed to deserialize");
                }
            }
        }
    }

    public static interface Visitor<T> {
        public T visit(String var1);

        public T visit(double var1);

        public T visit(boolean var1);

        public T visit(List<Object> var1);
    }
}

