/**
 * This file was auto-generated by Fern from our API Definition.
 */

package resources.assets.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(
    builder = ExportRuleRequest.Builder.class
)
public final class ExportRuleRequest {
  private final String id;

  private final Map<String, Object> additionalProperties;

  private ExportRuleRequest(String id, Map<String, Object> additionalProperties) {
    this.id = id;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The ID of the rule to export.
   */
  @JsonProperty("id")
  public String getId() {
    return id;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ExportRuleRequest && equalTo((ExportRuleRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ExportRuleRequest other) {
    return id.equals(other.id);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static IdStage builder() {
    return new Builder();
  }

  public interface IdStage {
    _FinalStage id(String id);

    Builder from(ExportRuleRequest other);
  }

  public interface _FinalStage {
    ExportRuleRequest build();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements IdStage, _FinalStage {
    private String id;

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(ExportRuleRequest other) {
      id(other.getId());
      return this;
    }

    /**
     * <p>The ID of the rule to export.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("id")
    public _FinalStage id(String id) {
      this.id = id;
      return this;
    }

    @java.lang.Override
    public ExportRuleRequest build() {
      return new ExportRuleRequest(id, additionalProperties);
    }
  }
}
