/**
 * This file was auto-generated by Fern from our API Definition.
 */

package resources.assets.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(
    builder = UpsertFolderRequest.Builder.class
)
public final class UpsertFolderRequest {
  private final Optional<String> id;

  private final String name;

  private final Optional<String> description;

  private final Map<String, Object> additionalProperties;

  private UpsertFolderRequest(Optional<String> id, String name, Optional<String> description,
      Map<String, Object> additionalProperties) {
    this.id = id;
    this.name = name;
    this.description = description;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Folder ID (required for updates, omit for creation)
   */
  @JsonProperty("id")
  public Optional<String> getId() {
    return id;
  }

  /**
   * @return Name of the folder
   */
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  /**
   * @return Description of the folder
   */
  @JsonProperty("description")
  public Optional<String> getDescription() {
    return description;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof UpsertFolderRequest && equalTo((UpsertFolderRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(UpsertFolderRequest other) {
    return id.equals(other.id) && name.equals(other.name) && description.equals(other.description);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id, this.name, this.description);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static NameStage builder() {
    return new Builder();
  }

  public interface NameStage {
    _FinalStage name(String name);

    Builder from(UpsertFolderRequest other);
  }

  public interface _FinalStage {
    UpsertFolderRequest build();

    _FinalStage id(Optional<String> id);

    _FinalStage id(String id);

    _FinalStage description(Optional<String> description);

    _FinalStage description(String description);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements NameStage, _FinalStage {
    private String name;

    private Optional<String> description = Optional.empty();

    private Optional<String> id = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(UpsertFolderRequest other) {
      id(other.getId());
      name(other.getName());
      description(other.getDescription());
      return this;
    }

    /**
     * <p>Name of the folder</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("name")
    public _FinalStage name(String name) {
      this.name = name;
      return this;
    }

    /**
     * <p>Description of the folder</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage description(String description) {
      this.description = Optional.of(description);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "description",
        nulls = Nulls.SKIP
    )
    public _FinalStage description(Optional<String> description) {
      this.description = description;
      return this;
    }

    /**
     * <p>Folder ID (required for updates, omit for creation)</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage id(String id) {
      this.id = Optional.of(id);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "id",
        nulls = Nulls.SKIP
    )
    public _FinalStage id(Optional<String> id) {
      this.id = id;
      return this;
    }

    @java.lang.Override
    public UpsertFolderRequest build() {
      return new UpsertFolderRequest(id, name, description, additionalProperties);
    }
  }
}
