/**
 * This file was auto-generated by Fern from our API Definition.
 */

package resources.assets.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(
    builder = ImportRuleResponse.Builder.class
)
public final class ImportRuleResponse {
  private final Optional<String> name;

  private final Optional<String> id;

  private final Optional<String> slug;

  private final Map<String, Object> additionalProperties;

  private ImportRuleResponse(Optional<String> name, Optional<String> id, Optional<String> slug,
      Map<String, Object> additionalProperties) {
    this.name = name;
    this.id = id;
    this.slug = slug;
    this.additionalProperties = additionalProperties;
  }

  @JsonProperty("name")
  public Optional<String> getName() {
    return name;
  }

  @JsonProperty("id")
  public Optional<String> getId() {
    return id;
  }

  @JsonProperty("slug")
  public Optional<String> getSlug() {
    return slug;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ImportRuleResponse && equalTo((ImportRuleResponse) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ImportRuleResponse other) {
    return name.equals(other.name) && id.equals(other.id) && slug.equals(other.slug);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.name, this.id, this.slug);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> name = Optional.empty();

    private Optional<String> id = Optional.empty();

    private Optional<String> slug = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(ImportRuleResponse other) {
      name(other.getName());
      id(other.getId());
      slug(other.getSlug());
      return this;
    }

    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public Builder name(Optional<String> name) {
      this.name = name;
      return this;
    }

    public Builder name(String name) {
      this.name = Optional.of(name);
      return this;
    }

    @JsonSetter(
        value = "id",
        nulls = Nulls.SKIP
    )
    public Builder id(Optional<String> id) {
      this.id = id;
      return this;
    }

    public Builder id(String id) {
      this.id = Optional.of(id);
      return this;
    }

    @JsonSetter(
        value = "slug",
        nulls = Nulls.SKIP
    )
    public Builder slug(Optional<String> slug) {
      this.slug = slug;
      return this;
    }

    public Builder slug(String slug) {
      this.slug = Optional.of(slug);
      return this;
    }

    public ImportRuleResponse build() {
      return new ImportRuleResponse(name, id, slug, additionalProperties);
    }
  }
}
