/**
 * This file was auto-generated by Fern from our API Definition.
 */

package resources.assets.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(
    builder = ListRulesResponseItem.Builder.class
)
public final class ListRulesResponseItem {
  private final Optional<String> id;

  private final Optional<OffsetDateTime> createdAt;

  private final Optional<String> name;

  private final Optional<String> description;

  private final Optional<String> slug;

  private final Optional<ListRulesResponseItemFolder> folder;

  private final Optional<List<Object>> requestSchema;

  private final Optional<List<Object>> responseSchema;

  private final Map<String, Object> additionalProperties;

  private ListRulesResponseItem(Optional<String> id, Optional<OffsetDateTime> createdAt,
      Optional<String> name, Optional<String> description, Optional<String> slug,
      Optional<ListRulesResponseItemFolder> folder, Optional<List<Object>> requestSchema,
      Optional<List<Object>> responseSchema, Map<String, Object> additionalProperties) {
    this.id = id;
    this.createdAt = createdAt;
    this.name = name;
    this.description = description;
    this.slug = slug;
    this.folder = folder;
    this.requestSchema = requestSchema;
    this.responseSchema = responseSchema;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The unique identifier for the rule.
   */
  @JsonProperty("id")
  public Optional<String> getId() {
    return id;
  }

  /**
   * @return The date this rule was created.
   */
  @JsonProperty("created_at")
  public Optional<OffsetDateTime> getCreatedAt() {
    return createdAt;
  }

  /**
   * @return The name of the rule.
   */
  @JsonProperty("name")
  public Optional<String> getName() {
    return name;
  }

  /**
   * @return The description of the rule.
   */
  @JsonProperty("description")
  public Optional<String> getDescription() {
    return description;
  }

  /**
   * @return The unique slug for the rule used in API requests.
   */
  @JsonProperty("slug")
  public Optional<String> getSlug() {
    return slug;
  }

  /**
   * @return The folder containing this rule
   */
  @JsonProperty("folder")
  public Optional<ListRulesResponseItemFolder> getFolder() {
    return folder;
  }

  /**
   * @return The published request schema for the rule.
   */
  @JsonProperty("request_schema")
  public Optional<List<Object>> getRequestSchema() {
    return requestSchema;
  }

  /**
   * @return The published response schema for the rule.
   */
  @JsonProperty("response_schema")
  public Optional<List<Object>> getResponseSchema() {
    return responseSchema;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ListRulesResponseItem && equalTo((ListRulesResponseItem) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ListRulesResponseItem other) {
    return id.equals(other.id) && createdAt.equals(other.createdAt) && name.equals(other.name) && description.equals(other.description) && slug.equals(other.slug) && folder.equals(other.folder) && requestSchema.equals(other.requestSchema) && responseSchema.equals(other.responseSchema);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id, this.createdAt, this.name, this.description, this.slug, this.folder, this.requestSchema, this.responseSchema);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> id = Optional.empty();

    private Optional<OffsetDateTime> createdAt = Optional.empty();

    private Optional<String> name = Optional.empty();

    private Optional<String> description = Optional.empty();

    private Optional<String> slug = Optional.empty();

    private Optional<ListRulesResponseItemFolder> folder = Optional.empty();

    private Optional<List<Object>> requestSchema = Optional.empty();

    private Optional<List<Object>> responseSchema = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(ListRulesResponseItem other) {
      id(other.getId());
      createdAt(other.getCreatedAt());
      name(other.getName());
      description(other.getDescription());
      slug(other.getSlug());
      folder(other.getFolder());
      requestSchema(other.getRequestSchema());
      responseSchema(other.getResponseSchema());
      return this;
    }

    @JsonSetter(
        value = "id",
        nulls = Nulls.SKIP
    )
    public Builder id(Optional<String> id) {
      this.id = id;
      return this;
    }

    public Builder id(String id) {
      this.id = Optional.of(id);
      return this;
    }

    @JsonSetter(
        value = "created_at",
        nulls = Nulls.SKIP
    )
    public Builder createdAt(Optional<OffsetDateTime> createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = Optional.of(createdAt);
      return this;
    }

    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public Builder name(Optional<String> name) {
      this.name = name;
      return this;
    }

    public Builder name(String name) {
      this.name = Optional.of(name);
      return this;
    }

    @JsonSetter(
        value = "description",
        nulls = Nulls.SKIP
    )
    public Builder description(Optional<String> description) {
      this.description = description;
      return this;
    }

    public Builder description(String description) {
      this.description = Optional.of(description);
      return this;
    }

    @JsonSetter(
        value = "slug",
        nulls = Nulls.SKIP
    )
    public Builder slug(Optional<String> slug) {
      this.slug = slug;
      return this;
    }

    public Builder slug(String slug) {
      this.slug = Optional.of(slug);
      return this;
    }

    @JsonSetter(
        value = "folder",
        nulls = Nulls.SKIP
    )
    public Builder folder(Optional<ListRulesResponseItemFolder> folder) {
      this.folder = folder;
      return this;
    }

    public Builder folder(ListRulesResponseItemFolder folder) {
      this.folder = Optional.of(folder);
      return this;
    }

    @JsonSetter(
        value = "request_schema",
        nulls = Nulls.SKIP
    )
    public Builder requestSchema(Optional<List<Object>> requestSchema) {
      this.requestSchema = requestSchema;
      return this;
    }

    public Builder requestSchema(List<Object> requestSchema) {
      this.requestSchema = Optional.of(requestSchema);
      return this;
    }

    @JsonSetter(
        value = "response_schema",
        nulls = Nulls.SKIP
    )
    public Builder responseSchema(Optional<List<Object>> responseSchema) {
      this.responseSchema = responseSchema;
      return this;
    }

    public Builder responseSchema(List<Object> responseSchema) {
      this.responseSchema = Optional.of(responseSchema);
      return this;
    }

    public ListRulesResponseItem build() {
      return new ListRulesResponseItem(id, createdAt, name, description, slug, folder, requestSchema, responseSchema, additionalProperties);
    }
  }
}
