/**
 * This file was auto-generated by Fern from our API Definition.
 */

package resources.assets.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.lang.Double;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(
    builder = UsageResponse.Builder.class
)
public final class UsageResponse {
  private final Optional<String> plan;

  private final Optional<String> monthlyPeriodStart;

  private final Optional<String> monthlyPeriodEnd;

  private final Optional<Double> monthlyExecutionsUsage;

  private final Optional<Double> monthlyExecutionsLimit;

  private final Optional<Double> monthlyExecutionsRemaining;

  private final Map<String, Object> additionalProperties;

  private UsageResponse(Optional<String> plan, Optional<String> monthlyPeriodStart,
      Optional<String> monthlyPeriodEnd, Optional<Double> monthlyExecutionsUsage,
      Optional<Double> monthlyExecutionsLimit, Optional<Double> monthlyExecutionsRemaining,
      Map<String, Object> additionalProperties) {
    this.plan = plan;
    this.monthlyPeriodStart = monthlyPeriodStart;
    this.monthlyPeriodEnd = monthlyPeriodEnd;
    this.monthlyExecutionsUsage = monthlyExecutionsUsage;
    this.monthlyExecutionsLimit = monthlyExecutionsLimit;
    this.monthlyExecutionsRemaining = monthlyExecutionsRemaining;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The current plan of the organization.
   */
  @JsonProperty("plan")
  public Optional<String> getPlan() {
    return plan;
  }

  /**
   * @return The start date of the current monthly period.
   */
  @JsonProperty("monthly_period_start")
  public Optional<String> getMonthlyPeriodStart() {
    return monthlyPeriodStart;
  }

  /**
   * @return The end date of the current monthly period.
   */
  @JsonProperty("monthly_period_end")
  public Optional<String> getMonthlyPeriodEnd() {
    return monthlyPeriodEnd;
  }

  /**
   * @return The number of rule executions used this month.
   */
  @JsonProperty("monthly_executions_usage")
  public Optional<Double> getMonthlyExecutionsUsage() {
    return monthlyExecutionsUsage;
  }

  /**
   * @return The total number of rule executions allowed this month.
   */
  @JsonProperty("monthly_executions_limit")
  public Optional<Double> getMonthlyExecutionsLimit() {
    return monthlyExecutionsLimit;
  }

  /**
   * @return The number of rule executions remaining this month.
   */
  @JsonProperty("monthly_executions_remaining")
  public Optional<Double> getMonthlyExecutionsRemaining() {
    return monthlyExecutionsRemaining;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof UsageResponse && equalTo((UsageResponse) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(UsageResponse other) {
    return plan.equals(other.plan) && monthlyPeriodStart.equals(other.monthlyPeriodStart) && monthlyPeriodEnd.equals(other.monthlyPeriodEnd) && monthlyExecutionsUsage.equals(other.monthlyExecutionsUsage) && monthlyExecutionsLimit.equals(other.monthlyExecutionsLimit) && monthlyExecutionsRemaining.equals(other.monthlyExecutionsRemaining);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.plan, this.monthlyPeriodStart, this.monthlyPeriodEnd, this.monthlyExecutionsUsage, this.monthlyExecutionsLimit, this.monthlyExecutionsRemaining);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> plan = Optional.empty();

    private Optional<String> monthlyPeriodStart = Optional.empty();

    private Optional<String> monthlyPeriodEnd = Optional.empty();

    private Optional<Double> monthlyExecutionsUsage = Optional.empty();

    private Optional<Double> monthlyExecutionsLimit = Optional.empty();

    private Optional<Double> monthlyExecutionsRemaining = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(UsageResponse other) {
      plan(other.getPlan());
      monthlyPeriodStart(other.getMonthlyPeriodStart());
      monthlyPeriodEnd(other.getMonthlyPeriodEnd());
      monthlyExecutionsUsage(other.getMonthlyExecutionsUsage());
      monthlyExecutionsLimit(other.getMonthlyExecutionsLimit());
      monthlyExecutionsRemaining(other.getMonthlyExecutionsRemaining());
      return this;
    }

    @JsonSetter(
        value = "plan",
        nulls = Nulls.SKIP
    )
    public Builder plan(Optional<String> plan) {
      this.plan = plan;
      return this;
    }

    public Builder plan(String plan) {
      this.plan = Optional.of(plan);
      return this;
    }

    @JsonSetter(
        value = "monthly_period_start",
        nulls = Nulls.SKIP
    )
    public Builder monthlyPeriodStart(Optional<String> monthlyPeriodStart) {
      this.monthlyPeriodStart = monthlyPeriodStart;
      return this;
    }

    public Builder monthlyPeriodStart(String monthlyPeriodStart) {
      this.monthlyPeriodStart = Optional.of(monthlyPeriodStart);
      return this;
    }

    @JsonSetter(
        value = "monthly_period_end",
        nulls = Nulls.SKIP
    )
    public Builder monthlyPeriodEnd(Optional<String> monthlyPeriodEnd) {
      this.monthlyPeriodEnd = monthlyPeriodEnd;
      return this;
    }

    public Builder monthlyPeriodEnd(String monthlyPeriodEnd) {
      this.monthlyPeriodEnd = Optional.of(monthlyPeriodEnd);
      return this;
    }

    @JsonSetter(
        value = "monthly_executions_usage",
        nulls = Nulls.SKIP
    )
    public Builder monthlyExecutionsUsage(Optional<Double> monthlyExecutionsUsage) {
      this.monthlyExecutionsUsage = monthlyExecutionsUsage;
      return this;
    }

    public Builder monthlyExecutionsUsage(Double monthlyExecutionsUsage) {
      this.monthlyExecutionsUsage = Optional.of(monthlyExecutionsUsage);
      return this;
    }

    @JsonSetter(
        value = "monthly_executions_limit",
        nulls = Nulls.SKIP
    )
    public Builder monthlyExecutionsLimit(Optional<Double> monthlyExecutionsLimit) {
      this.monthlyExecutionsLimit = monthlyExecutionsLimit;
      return this;
    }

    public Builder monthlyExecutionsLimit(Double monthlyExecutionsLimit) {
      this.monthlyExecutionsLimit = Optional.of(monthlyExecutionsLimit);
      return this;
    }

    @JsonSetter(
        value = "monthly_executions_remaining",
        nulls = Nulls.SKIP
    )
    public Builder monthlyExecutionsRemaining(Optional<Double> monthlyExecutionsRemaining) {
      this.monthlyExecutionsRemaining = monthlyExecutionsRemaining;
      return this;
    }

    public Builder monthlyExecutionsRemaining(Double monthlyExecutionsRemaining) {
      this.monthlyExecutionsRemaining = Optional.of(monthlyExecutionsRemaining);
      return this;
    }

    public UsageResponse build() {
      return new UsageResponse(plan, monthlyPeriodStart, monthlyPeriodEnd, monthlyExecutionsUsage, monthlyExecutionsLimit, monthlyExecutionsRemaining, additionalProperties);
    }
  }
}
