/**
 * This file was auto-generated by Fern from our API Definition.
 */

package resources.tests.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(
    builder = CreateFlowTestRequest.Builder.class
)
public final class CreateFlowTestRequest {
  private final String name;

  private final Map<String, Object> request;

  private final Map<String, Object> response;

  private final boolean critical;

  private final Map<String, Object> additionalProperties;

  private CreateFlowTestRequest(String name, Map<String, Object> request,
      Map<String, Object> response, boolean critical, Map<String, Object> additionalProperties) {
    this.name = name;
    this.request = request;
    this.response = response;
    this.critical = critical;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The name of the test.
   */
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  /**
   * @return The request object for the test.
   */
  @JsonProperty("request")
  public Map<String, Object> getRequest() {
    return request;
  }

  /**
   * @return The expected response object for the test.
   */
  @JsonProperty("response")
  public Map<String, Object> getResponse() {
    return response;
  }

  /**
   * @return Indicates whether the test is critical.
   */
  @JsonProperty("critical")
  public boolean getCritical() {
    return critical;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof CreateFlowTestRequest && equalTo((CreateFlowTestRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(CreateFlowTestRequest other) {
    return name.equals(other.name) && request.equals(other.request) && response.equals(other.response) && critical == other.critical;
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.name, this.request, this.response, this.critical);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static NameStage builder() {
    return new Builder();
  }

  public interface NameStage {
    CriticalStage name(String name);

    Builder from(CreateFlowTestRequest other);
  }

  public interface CriticalStage {
    _FinalStage critical(boolean critical);
  }

  public interface _FinalStage {
    CreateFlowTestRequest build();

    _FinalStage request(Map<String, Object> request);

    _FinalStage putAllRequest(Map<String, Object> request);

    _FinalStage request(String key, Object value);

    _FinalStage response(Map<String, Object> response);

    _FinalStage putAllResponse(Map<String, Object> response);

    _FinalStage response(String key, Object value);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements NameStage, CriticalStage, _FinalStage {
    private String name;

    private boolean critical;

    private Map<String, Object> response = new LinkedHashMap<>();

    private Map<String, Object> request = new LinkedHashMap<>();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(CreateFlowTestRequest other) {
      name(other.getName());
      request(other.getRequest());
      response(other.getResponse());
      critical(other.getCritical());
      return this;
    }

    /**
     * <p>The name of the test.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("name")
    public CriticalStage name(String name) {
      this.name = name;
      return this;
    }

    /**
     * <p>Indicates whether the test is critical.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("critical")
    public _FinalStage critical(boolean critical) {
      this.critical = critical;
      return this;
    }

    /**
     * <p>The expected response object for the test.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage response(String key, Object value) {
      this.response.put(key, value);
      return this;
    }

    /**
     * <p>The expected response object for the test.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage putAllResponse(Map<String, Object> response) {
      this.response.putAll(response);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "response",
        nulls = Nulls.SKIP
    )
    public _FinalStage response(Map<String, Object> response) {
      this.response.clear();
      this.response.putAll(response);
      return this;
    }

    /**
     * <p>The request object for the test.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage request(String key, Object value) {
      this.request.put(key, value);
      return this;
    }

    /**
     * <p>The request object for the test.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage putAllRequest(Map<String, Object> request) {
      this.request.putAll(request);
      return this;
    }

    @java.lang.Override
    @JsonSetter(
        value = "request",
        nulls = Nulls.SKIP
    )
    public _FinalStage request(Map<String, Object> request) {
      this.request.clear();
      this.request.putAll(request);
      return this;
    }

    @java.lang.Override
    public CreateFlowTestRequest build() {
      return new CreateFlowTestRequest(name, request, response, critical, additionalProperties);
    }
  }
}
