/*
 * Decompiled with CFR 0.152.
 */
package resources.assets.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ImportRuleResponse {
    private final Optional<String> name;
    private final Optional<String> id;
    private final Optional<String> slug;
    private final Map<String, Object> additionalProperties;

    private ImportRuleResponse(Optional<String> name, Optional<String> id, Optional<String> slug, Map<String, Object> additionalProperties) {
        this.name = name;
        this.id = id;
        this.slug = slug;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="slug")
    public Optional<String> getSlug() {
        return this.slug;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ImportRuleResponse && this.equalTo((ImportRuleResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ImportRuleResponse other) {
        return this.name.equals(other.name) && this.id.equals(other.id) && this.slug.equals(other.slug);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.id, this.slug);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<String> slug = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ImportRuleResponse other) {
            this.name(other.getName());
            this.id(other.getId());
            this.slug(other.getSlug());
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="slug", nulls=Nulls.SKIP)
        public Builder slug(Optional<String> slug) {
            this.slug = slug;
            return this;
        }

        public Builder slug(String slug) {
            this.slug = Optional.of(slug);
            return this;
        }

        public ImportRuleResponse build() {
            return new ImportRuleResponse(this.name, this.id, this.slug, this.additionalProperties);
        }
    }
}

