/*
 * Decompiled with CFR 0.152.
 */
package resources.users.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import resources.users.types.InviteRequestRole;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class InviteRequest {
    private final String email;
    private final Optional<InviteRequestRole> role;
    private final Optional<List<String>> accessGroups;
    private final Map<String, Object> additionalProperties;

    private InviteRequest(String email, Optional<InviteRequestRole> role, Optional<List<String>> accessGroups, Map<String, Object> additionalProperties) {
        this.email = email;
        this.role = role;
        this.accessGroups = accessGroups;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="role")
    public Optional<InviteRequestRole> getRole() {
        return this.role;
    }

    @JsonProperty(value="accessGroups")
    public Optional<List<String>> getAccessGroups() {
        return this.accessGroups;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof InviteRequest && this.equalTo((InviteRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(InviteRequest other) {
        return this.email.equals(other.email) && this.role.equals(other.role) && this.accessGroups.equals(other.accessGroups);
    }

    public int hashCode() {
        return Objects.hash(this.email, this.role, this.accessGroups);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static EmailStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements EmailStage,
    _FinalStage {
        private String email;
        private Optional<List<String>> accessGroups = Optional.empty();
        private Optional<InviteRequestRole> role = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(InviteRequest other) {
            this.email(other.getEmail());
            this.role(other.getRole());
            this.accessGroups(other.getAccessGroups());
            return this;
        }

        @Override
        @JsonSetter(value="email")
        public _FinalStage email(String email) {
            this.email = email;
            return this;
        }

        @Override
        public _FinalStage accessGroups(List<String> accessGroups) {
            this.accessGroups = Optional.of(accessGroups);
            return this;
        }

        @Override
        @JsonSetter(value="accessGroups", nulls=Nulls.SKIP)
        public _FinalStage accessGroups(Optional<List<String>> accessGroups) {
            this.accessGroups = accessGroups;
            return this;
        }

        @Override
        public _FinalStage role(InviteRequestRole role) {
            this.role = Optional.of(role);
            return this;
        }

        @Override
        @JsonSetter(value="role", nulls=Nulls.SKIP)
        public _FinalStage role(Optional<InviteRequestRole> role) {
            this.role = role;
            return this;
        }

        @Override
        public InviteRequest build() {
            return new InviteRequest(this.email, this.role, this.accessGroups, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public InviteRequest build();

        public _FinalStage role(Optional<InviteRequestRole> var1);

        public _FinalStage role(InviteRequestRole var1);

        public _FinalStage accessGroups(Optional<List<String>> var1);

        public _FinalStage accessGroups(List<String> var1);
    }

    public static interface EmailStage {
        public _FinalStage email(String var1);

        public Builder from(InviteRequest var1);
    }
}

