/*
 * Decompiled with CFR 0.152.
 */
package resources.decisions;

import core.ApiError;
import core.ClientOptions;
import core.ObjectMappers;
import core.RequestOptions;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import resources.decisions.requests.QueryRequest;
import resources.decisions.types.QueryResponse;

public class DecisionsClient {
    protected final ClientOptions clientOptions;

    public DecisionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public QueryResponse query(QueryRequest request) {
        return this.query(request, null);
    }

    public QueryResponse query(QueryRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("api/v1/decisions/query");
        httpUrl.addQueryParameter("slug", request.getSlug());
        if (request.getFrom().isPresent()) {
            httpUrl.addQueryParameter("from", request.getFrom().get().toString());
        }
        if (request.getTo().isPresent()) {
            httpUrl.addQueryParameter("to", request.getTo().get().toString());
        }
        if (request.getCursor().isPresent()) {
            httpUrl.addQueryParameter("cursor", request.getCursor().get());
        }
        if (request.getLimit().isPresent()) {
            httpUrl.addQueryParameter("limit", request.getLimit().get().toString());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (QueryResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), QueryResponse.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

