/*
 * Decompiled with CFR 0.152.
 */
package resources.decisions.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class QueryRequest {
    private final String slug;
    private final Optional<OffsetDateTime> from;
    private final Optional<OffsetDateTime> to;
    private final Optional<String> cursor;
    private final Optional<Integer> limit;
    private final Map<String, Object> additionalProperties;

    private QueryRequest(String slug, Optional<OffsetDateTime> from, Optional<OffsetDateTime> to, Optional<String> cursor, Optional<Integer> limit, Map<String, Object> additionalProperties) {
        this.slug = slug;
        this.from = from;
        this.to = to;
        this.cursor = cursor;
        this.limit = limit;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="slug")
    public String getSlug() {
        return this.slug;
    }

    @JsonProperty(value="from")
    public Optional<OffsetDateTime> getFrom() {
        return this.from;
    }

    @JsonProperty(value="to")
    public Optional<OffsetDateTime> getTo() {
        return this.to;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof QueryRequest && this.equalTo((QueryRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(QueryRequest other) {
        return this.slug.equals(other.slug) && this.from.equals(other.from) && this.to.equals(other.to) && this.cursor.equals(other.cursor) && this.limit.equals(other.limit);
    }

    public int hashCode() {
        return Objects.hash(this.slug, this.from, this.to, this.cursor, this.limit);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SlugStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SlugStage,
    _FinalStage {
        private String slug;
        private Optional<Integer> limit = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<OffsetDateTime> to = Optional.empty();
        private Optional<OffsetDateTime> from = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(QueryRequest other) {
            this.slug(other.getSlug());
            this.from(other.getFrom());
            this.to(other.getTo());
            this.cursor(other.getCursor());
            this.limit(other.getLimit());
            return this;
        }

        @Override
        @JsonSetter(value="slug")
        public _FinalStage slug(String slug) {
            this.slug = slug;
            return this;
        }

        @Override
        public _FinalStage limit(Integer limit) {
            this.limit = Optional.of(limit);
            return this;
        }

        @Override
        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public _FinalStage limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public _FinalStage cursor(String cursor) {
            this.cursor = Optional.of(cursor);
            return this;
        }

        @Override
        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public _FinalStage cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        @Override
        public _FinalStage to(OffsetDateTime to) {
            this.to = Optional.of(to);
            return this;
        }

        @Override
        @JsonSetter(value="to", nulls=Nulls.SKIP)
        public _FinalStage to(Optional<OffsetDateTime> to) {
            this.to = to;
            return this;
        }

        @Override
        public _FinalStage from(OffsetDateTime from) {
            this.from = Optional.of(from);
            return this;
        }

        @Override
        @JsonSetter(value="from", nulls=Nulls.SKIP)
        public _FinalStage from(Optional<OffsetDateTime> from) {
            this.from = from;
            return this;
        }

        @Override
        public QueryRequest build() {
            return new QueryRequest(this.slug, this.from, this.to, this.cursor, this.limit, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public QueryRequest build();

        public _FinalStage from(Optional<OffsetDateTime> var1);

        public _FinalStage from(OffsetDateTime var1);

        public _FinalStage to(Optional<OffsetDateTime> var1);

        public _FinalStage to(OffsetDateTime var1);

        public _FinalStage cursor(Optional<String> var1);

        public _FinalStage cursor(String var1);

        public _FinalStage limit(Optional<Integer> var1);

        public _FinalStage limit(Integer var1);
    }

    public static interface SlugStage {
        public _FinalStage slug(String var1);

        public Builder from(QueryRequest var1);
    }
}

