/**
 * This file was auto-generated by Fern from our API Definition.
 */

import core.ClientOptions;
import core.Environment;
import java.lang.String;
import okhttp3.OkHttpClient;

public final class AsyncRulebricksApiClientBuilder {
  private ClientOptions.Builder clientOptionsBuilder = ClientOptions.builder();

  private String apiKey = null;

  private Environment environment;

  /**
   * Sets apiKey
   */
  public AsyncRulebricksApiClientBuilder apiKey(String apiKey) {
    this.apiKey = apiKey;
    return this;
  }

  public AsyncRulebricksApiClientBuilder url(String url) {
    this.environment = Environment.custom(url);
    return this;
  }

  /**
   * Sets the timeout (in seconds) for the client. Defaults to 60 seconds.
   */
  public AsyncRulebricksApiClientBuilder timeout(int timeout) {
    this.clientOptionsBuilder.timeout(timeout);
    return this;
  }

  /**
   * Sets the maximum number of retries for the client. Defaults to 2 retries.
   */
  public AsyncRulebricksApiClientBuilder maxRetries(int maxRetries) {
    this.clientOptionsBuilder.maxRetries(maxRetries);
    return this;
  }

  /**
   * Sets the underlying OkHttp client
   */
  public AsyncRulebricksApiClientBuilder httpClient(OkHttpClient httpClient) {
    this.clientOptionsBuilder.httpClient(httpClient);
    return this;
  }

  public AsyncRulebricksApiClient build() {
    if (apiKey == null) {
      throw new RuntimeException("Please provide apiKey");
    }
    this.clientOptionsBuilder.addHeader("x-api-key", this.apiKey);
    clientOptionsBuilder.environment(this.environment);
    return new AsyncRulebricksApiClient(clientOptionsBuilder.build());
  }
}
