/**
 * This file was auto-generated by Fern from our API Definition.
 */

package resources.values.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = DeleteRequest.Builder.class
)
public final class DeleteRequest {
  private final String id;

  private final Map<String, Object> additionalProperties;

  private DeleteRequest(String id, Map<String, Object> additionalProperties) {
    this.id = id;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return ID of the dynamic value to delete
   */
  @JsonProperty("id")
  public String getId() {
    return id;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof DeleteRequest && equalTo((DeleteRequest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(DeleteRequest other) {
    return id.equals(other.id);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static IdStage builder() {
    return new Builder();
  }

  public interface IdStage {
    _FinalStage id(@NotNull String id);

    Builder from(DeleteRequest other);
  }

  public interface _FinalStage {
    DeleteRequest build();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements IdStage, _FinalStage {
    private String id;

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(DeleteRequest other) {
      id(other.getId());
      return this;
    }

    /**
     * <p>ID of the dynamic value to delete</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("id")
    public _FinalStage id(@NotNull String id) {
      this.id = Objects.requireNonNull(id, "id must not be null");
      return this;
    }

    @java.lang.Override
    public DeleteRequest build() {
      return new DeleteRequest(id, additionalProperties);
    }
  }
}
