/**
 * This file was auto-generated by Fern from our API Definition.
 */

package types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = DynamicValueBase.Builder.class
)
public final class DynamicValueBase implements IDynamicValueBase {
  private final Optional<String> id;

  private final Optional<String> name;

  private final Optional<List<RuleUsage>> usages;

  private final Optional<List<String>> accessGroups;

  private final Map<String, Object> additionalProperties;

  private DynamicValueBase(Optional<String> id, Optional<String> name,
      Optional<List<RuleUsage>> usages, Optional<List<String>> accessGroups,
      Map<String, Object> additionalProperties) {
    this.id = id;
    this.name = name;
    this.usages = usages;
    this.accessGroups = accessGroups;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Unique identifier for the dynamic value.
   */
  @JsonProperty("id")
  @java.lang.Override
  public Optional<String> getId() {
    return id;
  }

  /**
   * @return Name of the dynamic value.
   */
  @JsonProperty("name")
  @java.lang.Override
  public Optional<String> getName() {
    return name;
  }

  /**
   * @return Rules that use this dynamic value.
   */
  @JsonProperty("usages")
  @java.lang.Override
  public Optional<List<RuleUsage>> getUsages() {
    return usages;
  }

  /**
   * @return Access groups assigned to this value.
   */
  @JsonProperty("accessGroups")
  @java.lang.Override
  public Optional<List<String>> getAccessGroups() {
    return accessGroups;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof DynamicValueBase && equalTo((DynamicValueBase) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(DynamicValueBase other) {
    return id.equals(other.id) && name.equals(other.name) && usages.equals(other.usages) && accessGroups.equals(other.accessGroups);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id, this.name, this.usages, this.accessGroups);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> id = Optional.empty();

    private Optional<String> name = Optional.empty();

    private Optional<List<RuleUsage>> usages = Optional.empty();

    private Optional<List<String>> accessGroups = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(DynamicValueBase other) {
      id(other.getId());
      name(other.getName());
      usages(other.getUsages());
      accessGroups(other.getAccessGroups());
      return this;
    }

    @JsonSetter(
        value = "id",
        nulls = Nulls.SKIP
    )
    public Builder id(Optional<String> id) {
      this.id = id;
      return this;
    }

    public Builder id(String id) {
      this.id = Optional.ofNullable(id);
      return this;
    }

    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public Builder name(Optional<String> name) {
      this.name = name;
      return this;
    }

    public Builder name(String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }

    @JsonSetter(
        value = "usages",
        nulls = Nulls.SKIP
    )
    public Builder usages(Optional<List<RuleUsage>> usages) {
      this.usages = usages;
      return this;
    }

    public Builder usages(List<RuleUsage> usages) {
      this.usages = Optional.ofNullable(usages);
      return this;
    }

    @JsonSetter(
        value = "accessGroups",
        nulls = Nulls.SKIP
    )
    public Builder accessGroups(Optional<List<String>> accessGroups) {
      this.accessGroups = accessGroups;
      return this;
    }

    public Builder accessGroups(List<String> accessGroups) {
      this.accessGroups = Optional.ofNullable(accessGroups);
      return this;
    }

    public DynamicValueBase build() {
      return new DynamicValueBase(id, name, usages, accessGroups, additionalProperties);
    }
  }
}
