/*
 * Decompiled with CFR 0.152.
 */
import core.ClientOptions;
import core.Environment;
import okhttp3.OkHttpClient;

public final class AsyncRulebricksApiClientBuilder {
    private ClientOptions.Builder clientOptionsBuilder = ClientOptions.builder();
    private String apiKey = null;
    private Environment environment;

    public AsyncRulebricksApiClientBuilder apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public AsyncRulebricksApiClientBuilder url(String url) {
        this.environment = Environment.custom(url);
        return this;
    }

    public AsyncRulebricksApiClientBuilder timeout(int timeout) {
        this.clientOptionsBuilder.timeout(timeout);
        return this;
    }

    public AsyncRulebricksApiClientBuilder maxRetries(int maxRetries) {
        this.clientOptionsBuilder.maxRetries(maxRetries);
        return this;
    }

    public AsyncRulebricksApiClientBuilder httpClient(OkHttpClient httpClient) {
        this.clientOptionsBuilder.httpClient(httpClient);
        return this;
    }

    public AsyncRulebricksApiClient build() {
        if (this.apiKey == null) {
            throw new RuntimeException("Please provide apiKey");
        }
        this.clientOptionsBuilder.addHeader("x-api-key", this.apiKey);
        this.clientOptionsBuilder.environment(this.environment);
        return new AsyncRulebricksApiClient(this.clientOptionsBuilder.build());
    }
}

