/*
 * Decompiled with CFR 0.152.
 */
import core.ClientOptions;
import core.Environment;
import okhttp3.OkHttpClient;

public final class RulebricksApiClientBuilder {
    private ClientOptions.Builder clientOptionsBuilder = ClientOptions.builder();
    private String apiKey = null;
    private Environment environment;

    public RulebricksApiClientBuilder apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public RulebricksApiClientBuilder url(String url) {
        this.environment = Environment.custom(url);
        return this;
    }

    public RulebricksApiClientBuilder timeout(int timeout) {
        this.clientOptionsBuilder.timeout(timeout);
        return this;
    }

    public RulebricksApiClientBuilder maxRetries(int maxRetries) {
        this.clientOptionsBuilder.maxRetries(maxRetries);
        return this;
    }

    public RulebricksApiClientBuilder httpClient(OkHttpClient httpClient) {
        this.clientOptionsBuilder.httpClient(httpClient);
        return this;
    }

    public RulebricksApiClient build() {
        if (this.apiKey == null) {
            throw new RuntimeException("Please provide apiKey");
        }
        this.clientOptionsBuilder.addHeader("x-api-key", this.apiKey);
        this.clientOptionsBuilder.environment(this.environment);
        return new RulebricksApiClient(this.clientOptionsBuilder.build());
    }
}

