/*
 * Decompiled with CFR 0.152.
 */
package types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.Optional;

public final class DynamicValue {
    private final Value value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private DynamicValue(Value value) {
        this.value = value;
    }

    public <T> T visit(Visitor<T> visitor) {
        return this.value.visit(visitor);
    }

    public static DynamicValue string(types.StringValue value) {
        return new DynamicValue(new StringValue(value));
    }

    public static DynamicValue number(types.NumberValue value) {
        return new DynamicValue(new NumberValue(value));
    }

    public static DynamicValue boolean_(types.BooleanValue value) {
        return new DynamicValue(new BooleanValue(value));
    }

    public static DynamicValue list(types.ListValue value) {
        return new DynamicValue(new ListValue(value));
    }

    public boolean isString() {
        return this.value instanceof StringValue;
    }

    public boolean isNumber() {
        return this.value instanceof NumberValue;
    }

    public boolean isBoolean() {
        return this.value instanceof BooleanValue;
    }

    public boolean isList() {
        return this.value instanceof ListValue;
    }

    public boolean _isUnknown() {
        return this.value instanceof _UnknownValue;
    }

    public Optional<types.StringValue> getString() {
        if (this.isString()) {
            return Optional.of(((StringValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<types.NumberValue> getNumber() {
        if (this.isNumber()) {
            return Optional.of(((NumberValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<types.BooleanValue> getBoolean() {
        if (this.isBoolean()) {
            return Optional.of(((BooleanValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<types.ListValue> getList() {
        if (this.isList()) {
            return Optional.of(((ListValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<Object> _getUnknown() {
        if (this._isUnknown()) {
            return Optional.of(((_UnknownValue)this.value).value);
        }
        return Optional.empty();
    }

    @JsonValue
    private Value getValue() {
        return this.value;
    }

    @JsonIgnoreProperties(value={"type"})
    private static final class _UnknownValue
    implements Value {
        private String type;
        @JsonValue
        private Object value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private _UnknownValue(@JsonProperty(value="value") Object value) {
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor._visitUnknown(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof _UnknownValue && this.equalTo((_UnknownValue)other);
        }

        private boolean equalTo(_UnknownValue other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public String toString() {
            return "DynamicValue{type: " + this.type + ", value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="list")
    @JsonIgnoreProperties(value={"type"})
    private static final class ListValue
    implements Value {
        @JsonUnwrapped
        private types.ListValue value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ListValue() {
        }

        private ListValue(types.ListValue value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitList(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ListValue && this.equalTo((ListValue)other);
        }

        private boolean equalTo(ListValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "DynamicValue{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="boolean")
    @JsonIgnoreProperties(value={"type"})
    private static final class BooleanValue
    implements Value {
        @JsonUnwrapped
        private types.BooleanValue value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private BooleanValue() {
        }

        private BooleanValue(types.BooleanValue value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitBoolean(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof BooleanValue && this.equalTo((BooleanValue)other);
        }

        private boolean equalTo(BooleanValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "DynamicValue{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="number")
    @JsonIgnoreProperties(value={"type"})
    private static final class NumberValue
    implements Value {
        @JsonUnwrapped
        private types.NumberValue value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private NumberValue() {
        }

        private NumberValue(types.NumberValue value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitNumber(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof NumberValue && this.equalTo((NumberValue)other);
        }

        private boolean equalTo(NumberValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "DynamicValue{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="string")
    @JsonIgnoreProperties(value={"type"})
    private static final class StringValue
    implements Value {
        @JsonUnwrapped
        private types.StringValue value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private StringValue() {
        }

        private StringValue(types.StringValue value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitString(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof StringValue && this.equalTo((StringValue)other);
        }

        private boolean equalTo(StringValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "DynamicValue{value: " + this.value + "}";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", visible=true, defaultImpl=_UnknownValue.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=StringValue.class), @JsonSubTypes.Type(value=NumberValue.class), @JsonSubTypes.Type(value=BooleanValue.class), @JsonSubTypes.Type(value=ListValue.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Value {
        public <T> T visit(Visitor<T> var1);
    }

    public static interface Visitor<T> {
        public T visitString(types.StringValue var1);

        public T visitNumber(types.NumberValue var1);

        public T visitBoolean(types.BooleanValue var1);

        public T visitList(types.ListValue var1);

        public T _visitUnknown(Object var1);
    }
}

