/*
 * Decompiled with CFR 0.152.
 */
package types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ParallelSolveRequestValue {
    private final Optional<String> rule;
    private final Optional<String> flow;
    private final Map<String, Object> additionalProperties;

    private ParallelSolveRequestValue(Optional<String> rule, Optional<String> flow, Map<String, Object> additionalProperties) {
        this.rule = rule;
        this.flow = flow;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="$rule")
    public Optional<String> getRule() {
        return this.rule;
    }

    @JsonProperty(value="$flow")
    public Optional<String> getFlow() {
        return this.flow;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ParallelSolveRequestValue && this.equalTo((ParallelSolveRequestValue)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ParallelSolveRequestValue other) {
        return this.rule.equals(other.rule) && this.flow.equals(other.flow);
    }

    public int hashCode() {
        return Objects.hash(this.rule, this.flow);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> rule = Optional.empty();
        private Optional<String> flow = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ParallelSolveRequestValue other) {
            this.rule(other.getRule());
            this.flow(other.getFlow());
            return this;
        }

        @JsonSetter(value="$rule", nulls=Nulls.SKIP)
        public Builder rule(Optional<String> rule) {
            this.rule = rule;
            return this;
        }

        public Builder rule(String rule) {
            this.rule = Optional.ofNullable(rule);
            return this;
        }

        @JsonSetter(value="$flow", nulls=Nulls.SKIP)
        public Builder flow(Optional<String> flow) {
            this.flow = flow;
            return this;
        }

        public Builder flow(String flow) {
            this.flow = Optional.ofNullable(flow);
            return this;
        }

        public ParallelSolveRequestValue build() {
            return new ParallelSolveRequestValue(this.rule, this.flow, this.additionalProperties);
        }
    }
}

