/*
 * Decompiled with CFR 0.152.
 */
package types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import types.IRuleBase;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class RuleBase
implements IRuleBase {
    private final Optional<String> id;
    private final Optional<String> name;
    private final Optional<String> description;
    private final Optional<String> slug;
    private final Map<String, Object> additionalProperties;

    private RuleBase(Optional<String> id, Optional<String> name, Optional<String> description, Optional<String> slug, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.slug = slug;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="slug")
    public Optional<String> getSlug() {
        return this.slug;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RuleBase && this.equalTo((RuleBase)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RuleBase other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.description.equals(other.description) && this.slug.equals(other.slug);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.slug);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> slug = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(RuleBase other) {
            this.id(other.getId());
            this.name(other.getName());
            this.description(other.getDescription());
            this.slug(other.getSlug());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @JsonSetter(value="slug", nulls=Nulls.SKIP)
        public Builder slug(Optional<String> slug) {
            this.slug = slug;
            return this;
        }

        public Builder slug(String slug) {
            this.slug = Optional.ofNullable(slug);
            return this;
        }

        public RuleBase build() {
            return new RuleBase(this.id, this.name, this.description, this.slug, this.additionalProperties);
        }
    }
}

