/*
 * Decompiled with CFR 0.152.
 */
package types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import types.UserInviteResponseUser;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UserInviteResponse {
    private final Optional<String> message;
    private final Optional<UserInviteResponseUser> user;
    private final Map<String, Object> additionalProperties;

    private UserInviteResponse(Optional<String> message, Optional<UserInviteResponseUser> user, Map<String, Object> additionalProperties) {
        this.message = message;
        this.user = user;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="message")
    public Optional<String> getMessage() {
        return this.message;
    }

    @JsonProperty(value="user")
    public Optional<UserInviteResponseUser> getUser() {
        return this.user;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UserInviteResponse && this.equalTo((UserInviteResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UserInviteResponse other) {
        return this.message.equals(other.message) && this.user.equals(other.user);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.user);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> message = Optional.empty();
        private Optional<UserInviteResponseUser> user = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(UserInviteResponse other) {
            this.message(other.getMessage());
            this.user(other.getUser());
            return this;
        }

        @JsonSetter(value="message", nulls=Nulls.SKIP)
        public Builder message(Optional<String> message) {
            this.message = message;
            return this;
        }

        public Builder message(String message) {
            this.message = Optional.ofNullable(message);
            return this;
        }

        @JsonSetter(value="user", nulls=Nulls.SKIP)
        public Builder user(Optional<UserInviteResponseUser> user) {
            this.user = user;
            return this;
        }

        public Builder user(UserInviteResponseUser user) {
            this.user = Optional.ofNullable(user);
            return this;
        }

        public UserInviteResponse build() {
            return new UserInviteResponse(this.message, this.user, this.additionalProperties);
        }
    }
}

