/**
 * This file was auto-generated by Fern from our API Definition.
 */

import core.ClientOptions;
import core.Suppliers;
import java.util.function.Supplier;
import resources.assets.AsyncAssetsClient;
import resources.decisions.AsyncDecisionsClient;
import resources.flows.AsyncFlowsClient;
import resources.rules.AsyncRulesClient;
import resources.tests.AsyncTestsClient;
import resources.users.AsyncUsersClient;
import resources.values.AsyncValuesClient;

public class AsyncRulebricksApiClient {
  protected final ClientOptions clientOptions;

  protected final Supplier<AsyncRulesClient> rulesClient;

  protected final Supplier<AsyncFlowsClient> flowsClient;

  protected final Supplier<AsyncDecisionsClient> decisionsClient;

  protected final Supplier<AsyncUsersClient> usersClient;

  protected final Supplier<AsyncAssetsClient> assetsClient;

  protected final Supplier<AsyncValuesClient> valuesClient;

  protected final Supplier<AsyncTestsClient> testsClient;

  public AsyncRulebricksApiClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
    this.rulesClient = Suppliers.memoize(() -> new AsyncRulesClient(clientOptions));
    this.flowsClient = Suppliers.memoize(() -> new AsyncFlowsClient(clientOptions));
    this.decisionsClient = Suppliers.memoize(() -> new AsyncDecisionsClient(clientOptions));
    this.usersClient = Suppliers.memoize(() -> new AsyncUsersClient(clientOptions));
    this.assetsClient = Suppliers.memoize(() -> new AsyncAssetsClient(clientOptions));
    this.valuesClient = Suppliers.memoize(() -> new AsyncValuesClient(clientOptions));
    this.testsClient = Suppliers.memoize(() -> new AsyncTestsClient(clientOptions));
  }

  public AsyncRulesClient rules() {
    return this.rulesClient.get();
  }

  public AsyncFlowsClient flows() {
    return this.flowsClient.get();
  }

  public AsyncDecisionsClient decisions() {
    return this.decisionsClient.get();
  }

  public AsyncUsersClient users() {
    return this.usersClient.get();
  }

  public AsyncAssetsClient assets() {
    return this.assetsClient.get();
  }

  public AsyncValuesClient values() {
    return this.valuesClient.get();
  }

  public AsyncTestsClient tests() {
    return this.testsClient.get();
  }

  public static AsyncRulebricksApiClientBuilder builder() {
    return new AsyncRulebricksApiClientBuilder();
  }
}
